/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.tagprocessor;

import java.io.IOException;
import java.nio.CharBuffer;
import org.sitemesh.tagprocessor.CharSequenceBuffer;
import org.sitemesh.tagprocessor.State;
import org.sitemesh.tagprocessor.Tag;
import org.sitemesh.tagprocessor.TagProcessorContext;
import org.sitemesh.tagprocessor.TagRule;
import org.sitemesh.tagprocessor.TagTokenizer;
import org.sitemesh.tagprocessor.util.CharSequenceList;

public class TagProcessor {
    private final CharBuffer in;
    private final CharSequenceList out;
    private final State defaultState;
    private State currentState;

    public TagProcessor(CharBuffer source) {
        this.currentState = this.defaultState = new State();
        this.in = source;
        this.out = new CharSequenceList();
    }

    public CharSequence getDefaultBufferContents() {
        return this.out;
    }

    public State defaultState() {
        return this.defaultState;
    }

    public void addRule(String name, TagRule rule) {
        this.defaultState.addRule(name, rule);
    }

    public void process() throws IOException {
        final Context context = new Context(this.out);
        TagTokenizer tokenizer = new TagTokenizer(this.in, new TagTokenizer.TokenHandler(){

            @Override
            public boolean shouldProcessTag(String name) {
                return TagProcessor.this.currentState.shouldProcessTag(name.toLowerCase());
            }

            @Override
            public void tag(Tag tag) throws IOException {
                TagRule tagRule = TagProcessor.this.currentState.getRule(tag.getName().toLowerCase());
                tagRule.setTagProcessorContext(context);
                tagRule.process(tag);
            }

            @Override
            public void text(CharSequence text) throws IOException {
                TagProcessor.this.currentState.handleText(text, context);
            }

            @Override
            public void warning(String message, int line, int column) {
            }
        });
        tokenizer.start();
    }

    private class Context
    implements TagProcessorContext {
        private CharSequenceBuffer[] buffers = new CharSequenceBuffer[10];
        private int size;

        public Context(CharSequenceBuffer defaultBuffer) {
            this.buffers[0] = defaultBuffer;
            this.size = 1;
        }

        @Override
        public State currentState() {
            return TagProcessor.this.currentState;
        }

        @Override
        public void changeState(State newState) {
            TagProcessor.this.currentState = newState;
        }

        @Override
        public void pushBuffer(CharSequenceBuffer customBuffer) {
            if (this.size == this.buffers.length) {
                CharSequenceBuffer[] newBuffers = new CharSequenceBuffer[this.buffers.length * 2];
                System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                this.buffers = newBuffers;
            }
            this.buffers[this.size++] = customBuffer;
        }

        @Override
        public void pushBuffer() {
            this.pushBuffer(new CharSequenceList());
        }

        @Override
        public Appendable currentBuffer() {
            return this.buffers[this.size - 1];
        }

        @Override
        public CharSequence currentBufferContents() {
            return this.buffers[this.size - 1];
        }

        @Override
        public void popBuffer() {
            this.buffers[--this.size] = null;
        }
    }
}

