/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.builder;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.sitemesh.DecoratorSelector;
import org.sitemesh.SiteMeshContext;
import org.sitemesh.config.MetaTagBasedDecoratorSelector;
import org.sitemesh.config.PathBasedDecoratorSelector;
import org.sitemesh.content.ContentProcessor;
import org.sitemesh.content.tagrules.TagBasedContentProcessor;
import org.sitemesh.content.tagrules.TagRuleBundle;
import org.sitemesh.content.tagrules.decorate.DecoratorTagRuleBundle;
import org.sitemesh.content.tagrules.html.CoreHtmlTagRuleBundle;

public abstract class BaseSiteMeshBuilder<BUILDER extends BaseSiteMeshBuilder, CONTEXT extends SiteMeshContext, RESULT> {
    private List<TagRuleBundle> tagRuleBundles = new LinkedList<TagRuleBundle>();
    private ContentProcessor customContentProcessor;
    private PathBasedDecoratorSelector<CONTEXT> pathBasedDecoratorSelector = new MetaTagBasedDecoratorSelector<CONTEXT>();
    private DecoratorSelector<CONTEXT> customDecoratorSelector;

    protected BaseSiteMeshBuilder() {
        this.setupDefaults();
    }

    public abstract RESULT create() throws IllegalStateException;

    protected void setupDefaults() {
        this.addTagRuleBundles(new CoreHtmlTagRuleBundle(), new DecoratorTagRuleBundle());
    }

    protected BUILDER self() {
        return (BUILDER)this;
    }

    public BUILDER addTagRuleBundle(TagRuleBundle bundle) {
        this.tagRuleBundles.add(bundle);
        return this.self();
    }

    public BUILDER addTagRuleBundles(TagRuleBundle ... bundles) {
        this.tagRuleBundles.addAll(Arrays.asList(bundles));
        return this.self();
    }

    public BUILDER addTagRuleBundles(Iterable<TagRuleBundle> bundles) {
        for (TagRuleBundle bundle : bundles) {
            this.tagRuleBundles.add(bundle);
        }
        return this.self();
    }

    public BUILDER clearTagRuleBundles() {
        this.tagRuleBundles.clear();
        return this.self();
    }

    public BUILDER setTagRuleBundles(TagRuleBundle ... bundles) {
        this.addTagRuleBundles(bundles);
        return this.self();
    }

    public BUILDER setTagRuleBundles(Iterable<TagRuleBundle> bundles) {
        this.addTagRuleBundles(bundles);
        return this.self();
    }

    public BUILDER setCustomContentProcessor(ContentProcessor contentProcessor) {
        this.customContentProcessor = contentProcessor;
        return this.self();
    }

    public ContentProcessor getContentProcessor() {
        if (this.customContentProcessor == null) {
            TagRuleBundle[] bundlesAsArray = this.tagRuleBundles.toArray(new TagRuleBundle[this.tagRuleBundles.size()]);
            return new TagBasedContentProcessor(bundlesAsArray);
        }
        return this.customContentProcessor;
    }

    public BUILDER addDecoratorPaths(String contentPath, String ... decoratorPaths) {
        this.pathBasedDecoratorSelector.put(contentPath, decoratorPaths);
        return this.self();
    }

    public BUILDER addDecoratorPaths(String contentPath, List<String> decoratorPaths) {
        this.pathBasedDecoratorSelector.put(contentPath, decoratorPaths.toArray(new String[decoratorPaths.size()]));
        return this.self();
    }

    public BUILDER addDecoratorPath(String contentPath, String decoratorPath) {
        this.addDecoratorPaths(contentPath, decoratorPath);
        return this.self();
    }

    public BUILDER setCustomDecoratorSelector(DecoratorSelector<CONTEXT> decoratorSelector) {
        if (decoratorSelector instanceof PathBasedDecoratorSelector) {
            this.pathBasedDecoratorSelector = (PathBasedDecoratorSelector)decoratorSelector;
        } else {
            this.customDecoratorSelector = decoratorSelector;
        }
        return this.self();
    }

    public DecoratorSelector<CONTEXT> getDecoratorSelector() {
        if (this.customDecoratorSelector != null) {
            return this.customDecoratorSelector;
        }
        return this.pathBasedDecoratorSelector;
    }
}

