/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal.socks.socks5server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SocksSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocksSession.class);
    private static int nextSessionId = 0;
    private final Socket socket;
    private final long id = ++nextSessionId;
    private InputStream inputStream;
    private OutputStream outputStream;
    private final SocketAddress clientAddress;

    public SocksSession(Socket socket) {
        if (!socket.isConnected()) {
            throw new IllegalArgumentException("Socket should be a connected socket");
        }
        this.socket = socket;
        try {
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        this.clientAddress = socket.getRemoteSocketAddress();
        LOGGER.info("SESSION[{}] opened from {}", (Object)this.getId(), (Object)this.clientAddress);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void write(byte[] bytes) throws IOException {
        this.outputStream.write(bytes, 0, bytes.length);
        this.outputStream.flush();
    }

    public long getId() {
        return this.id;
    }

    public SocketAddress getClientAddress() {
        return this.clientAddress;
    }

    public void close() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.socket != null && !this.socket.isClosed()) {
                LOGGER.trace("closing client socket");
                this.socket.close();
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String toString() {
        return "SESSION[" + this.id + "]" + "@" + this.clientAddress;
    }
}

