/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.email;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import org.simplejavamail.email.AttachmentResource;
import org.simplejavamail.email.EmailBuilder;
import org.simplejavamail.email.EmailException;
import org.simplejavamail.email.EqualsHelper;
import org.simplejavamail.email.Recipient;
import org.simplejavamail.internal.util.ConfigLoader;
import org.simplejavamail.internal.util.MimeMessageParser;

public class Email {
    private Recipient fromRecipient;
    private Recipient replyToRecipient;
    private String text;
    private String textHTML;
    private String subject;
    private final List<Recipient> recipients;
    private final List<AttachmentResource> embeddedImages;
    private final List<AttachmentResource> attachments;
    private final Map<String, String> headers;
    private boolean applyDKIMSignature = false;
    private InputStream dkimPrivateKeyInputStream;
    private String signingDomain;
    private String selector;
    private static final Pattern MATCH_INSIDE_CIDBRACKETS = Pattern.compile("<?([^>]*)>?");

    public Email() {
        this.recipients = new ArrayList<Recipient>();
        this.embeddedImages = new ArrayList<AttachmentResource>();
        this.attachments = new ArrayList<AttachmentResource>();
        this.headers = new HashMap<String, String>();
        if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_FROM_ADDRESS)) {
            this.setFromAddress((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_FROM_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_FROM_ADDRESS));
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_REPLYTO_ADDRESS)) {
            this.setReplyToAddress((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_REPLYTO_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_REPLYTO_ADDRESS));
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_TO_ADDRESS)) {
            this.addRecipient((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_TO_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_TO_ADDRESS), Message.RecipientType.TO);
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_CC_ADDRESS)) {
            this.addRecipient((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_CC_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_CC_ADDRESS), Message.RecipientType.CC);
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_BCC_ADDRESS)) {
            this.addRecipient((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_BCC_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_BCC_ADDRESS), Message.RecipientType.BCC);
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_SUBJECT)) {
            this.setSubject((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_SUBJECT));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void signWithDomainKey(File dkimPrivateKeyFile, String signingDomain, String selector) {
        FileInputStream dkimPrivateKeyInputStream = null;
        try {
            dkimPrivateKeyInputStream = new FileInputStream(dkimPrivateKeyFile);
            this.signWithDomainKey(dkimPrivateKeyInputStream, signingDomain, selector);
            if (dkimPrivateKeyInputStream == null) return;
        }
        catch (FileNotFoundException e) {
            try {
                throw new EmailException(String.format("Private key not found: %s", dkimPrivateKeyFile), e);
            }
            catch (Throwable throwable) {
                if (dkimPrivateKeyInputStream == null) throw throwable;
                try {
                    dkimPrivateKeyInputStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new EmailException(String.format("Was unable to close InputStream: %s", e2.getMessage()), e2);
                }
            }
        }
        try {
            dkimPrivateKeyInputStream.close();
            return;
        }
        catch (IOException e) {
            throw new EmailException(String.format("Was unable to close InputStream: %s", e.getMessage()), e);
        }
    }

    public void signWithDomainKey(InputStream dkimPrivateKeyInputStream, String signingDomain, String selector) {
        this.applyDKIMSignature = true;
        this.dkimPrivateKeyInputStream = dkimPrivateKeyInputStream;
        this.signingDomain = signingDomain;
        this.selector = selector;
    }

    public void setFromAddress(String name, String fromAddress) {
        this.fromRecipient = new Recipient(name, fromAddress, null);
    }

    public void setReplyToAddress(String name, String replyToAddress) {
        this.replyToRecipient = new Recipient(name, replyToAddress, null);
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTextHTML(String textHTML) {
        this.textHTML = textHTML;
    }

    public void addRecipient(String name, String address, Message.RecipientType type) {
        this.recipients.add(new Recipient(name, address, type));
    }

    public void addEmbeddedImage(String name, byte[] data, String mimetype) {
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(name);
        this.addEmbeddedImage(name, (DataSource)dataSource);
    }

    public void addEmbeddedImage(String name, DataSource imagedata) {
        this.embeddedImages.add(new AttachmentResource(name, imagedata));
    }

    public void addHeader(String name, Object value) {
        this.headers.put(name, String.valueOf(value));
    }

    public void addAttachment(String name, byte[] data, String mimetype) {
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(name);
        this.addAttachment(name, (DataSource)dataSource);
    }

    public void addAttachment(String name, DataSource filedata) {
        this.attachments.add(new AttachmentResource(name, filedata));
    }

    public Recipient getFromRecipient() {
        return this.fromRecipient;
    }

    public Recipient getReplyToRecipient() {
        return this.replyToRecipient;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getText() {
        return this.text;
    }

    public String getTextHTML() {
        return this.textHTML;
    }

    public List<AttachmentResource> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }

    public List<AttachmentResource> getEmbeddedImages() {
        return Collections.unmodifiableList(this.embeddedImages);
    }

    public List<Recipient> getRecipients() {
        return Collections.unmodifiableList(this.recipients);
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public boolean isApplyDKIMSignature() {
        return this.applyDKIMSignature;
    }

    public InputStream getDkimPrivateKeyInputStream() {
        return this.dkimPrivateKeyInputStream;
    }

    public String getSigningDomain() {
        return this.signingDomain;
    }

    public String getSelector() {
        return this.selector;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && EqualsHelper.equalsEmail(this, (Email)o);
    }

    public String toString() {
        return "Email{\n\tfromRecipient=" + this.fromRecipient + ",\n\treplyToRecipient=" + this.replyToRecipient + ",\n\ttext='" + this.text + '\'' + ",\n\ttextHTML='" + this.textHTML + '\'' + ",\n\tsubject='" + this.subject + '\'' + ",\n\trecipients=" + this.recipients + ",\n\tembeddedImages=" + this.embeddedImages + ",\n\tattachments=" + this.attachments + ",\n\theaders=" + this.headers + "\n}";
    }

    Email(EmailBuilder builder) {
        this.recipients = builder.getRecipients();
        this.embeddedImages = builder.getEmbeddedImages();
        this.attachments = builder.getAttachments();
        this.headers = builder.getHeaders();
        this.fromRecipient = builder.getFromRecipient();
        this.replyToRecipient = builder.getReplyToRecipient();
        this.text = builder.getText();
        this.textHTML = builder.getTextHTML();
        this.subject = builder.getSubject();
        if (builder.getDkimPrivateKeyFile() != null) {
            this.signWithDomainKey(builder.getDkimPrivateKeyFile(), builder.getSigningDomain(), builder.getSelector());
        } else if (builder.getDkimPrivateKeyInputStream() != null) {
            this.signWithDomainKey(builder.getDkimPrivateKeyInputStream(), builder.getSigningDomain(), builder.getSelector());
        }
    }

    public Email(MimeMessage mimeMessage) {
        this.recipients = new ArrayList<Recipient>();
        this.embeddedImages = new ArrayList<AttachmentResource>();
        this.attachments = new ArrayList<AttachmentResource>();
        this.headers = new HashMap<String, String>();
        try {
            this.fillEmailFromMimeMessage(new MimeMessageParser(mimeMessage).parse());
        }
        catch (IOException | MessagingException e) {
            throw new EmailException(String.format("Error parsing MimeMessage: %s", e.getMessage()), (Exception)e);
        }
    }

    private void fillEmailFromMimeMessage(MimeMessageParser parser) throws MessagingException {
        InternetAddress from = parser.getFrom();
        this.setFromAddress(from.getPersonal(), from.getAddress());
        InternetAddress replyTo = parser.getReplyTo();
        this.setReplyToAddress(replyTo.getPersonal(), replyTo.getAddress());
        for (Map.Entry<String, Object> entry : parser.getHeaders().entrySet()) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
        for (InternetAddress internetAddress : parser.getTo()) {
            this.addRecipient(internetAddress.getPersonal(), internetAddress.getAddress(), Message.RecipientType.TO);
        }
        for (InternetAddress internetAddress : parser.getCc()) {
            this.addRecipient(internetAddress.getPersonal(), internetAddress.getAddress(), Message.RecipientType.CC);
        }
        for (InternetAddress internetAddress : parser.getBcc()) {
            this.addRecipient(internetAddress.getPersonal(), internetAddress.getAddress(), Message.RecipientType.BCC);
        }
        this.setSubject(parser.getSubject());
        this.setText(parser.getPlainContent());
        this.setTextHTML(parser.getHtmlContent());
        for (Map.Entry<String, Object> entry : parser.getCidMap().entrySet()) {
            this.addEmbeddedImage(Email.extractCID(entry.getKey()), (DataSource)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : parser.getAttachmentList().entrySet()) {
            this.addAttachment(Email.extractCID(entry.getKey()), (DataSource)entry.getValue());
        }
    }

    static String extractCID(String cid) {
        return cid != null ? MATCH_INSIDE_CIDBRACKETS.matcher(cid).replaceAll("$1") : null;
    }
}

