/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.net.InetSocketAddress;
import java.util.List;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.redisson.client.protocol.decoder.ListScanResult;
import reactor.rx.Stream;
import reactor.rx.subscription.ReactiveSubscription;

public abstract class SetReactiveIterator<V>
extends Stream<V> {
    public void subscribe(Subscriber<? super V> t) {
        t.onSubscribe((Subscription)new ReactiveSubscription<V>(this, t){
            private List<V> firstValues;
            private long nextIterPos;
            private InetSocketAddress client;
            private long currentIndex;

            protected void onRequest(long n) {
                this.currentIndex = n;
                this.nextValues();
            }

            private void handle(List<V> vals) {
                for (Object val : vals) {
                    this.onNext(val);
                }
            }

            protected void nextValues() {
                final 1 m = this;
                SetReactiveIterator.this.scanIteratorReactive(this.client, this.nextIterPos).subscribe(new Subscriber<ListScanResult<V>>(){

                    public void onSubscribe(Subscription s) {
                        s.request(Long.MAX_VALUE);
                    }

                    public void onNext(ListScanResult<V> res) {
                        client = res.getRedisClient();
                        long prevIterPos = nextIterPos;
                        if (nextIterPos == 0L && firstValues == null) {
                            firstValues = res.getValues();
                        } else if (res.getValues().equals(firstValues)) {
                            m.onComplete();
                            currentIndex = 0L;
                            return;
                        }
                        nextIterPos = res.getPos();
                        if (prevIterPos == nextIterPos) {
                            nextIterPos = -1L;
                        }
                        this.handle(res.getValues());
                        if (currentIndex == 0L) {
                            return;
                        }
                        if (nextIterPos == -1L) {
                            m.onComplete();
                            currentIndex = 0L;
                        }
                    }

                    public void onError(Throwable error) {
                        m.onError(error);
                    }

                    public void onComplete() {
                        if (currentIndex == 0L) {
                            return;
                        }
                        this.nextValues();
                    }
                });
            }
        });
    }

    protected abstract Publisher<ListScanResult<V>> scanIteratorReactive(InetSocketAddress var1, long var2);
}

