/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.reactivestreams.Publisher;
import org.redisson.api.RHyperLogLogReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonExpirableReactive;

public class RedissonHyperLogLogReactive<V>
extends RedissonExpirableReactive
implements RHyperLogLogReactive<V> {
    public RedissonHyperLogLogReactive(CommandReactiveExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    public RedissonHyperLogLogReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
    }

    @Override
    public Publisher<Boolean> add(V obj) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.PFADD, this.getName(), obj);
    }

    @Override
    public Publisher<Boolean> addAll(Collection<V> objects) {
        ArrayList<String> args = new ArrayList<String>(objects.size() + 1);
        args.add(this.getName());
        args.addAll(objects);
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.PFADD, this.getName(), args.toArray());
    }

    @Override
    public Publisher<Long> count() {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.PFCOUNT, this.getName());
    }

    @Override
    public Publisher<Long> countWith(String ... otherLogNames) {
        ArrayList<String> args = new ArrayList<String>(otherLogNames.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(otherLogNames));
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.PFCOUNT, args.toArray());
    }

    @Override
    public Publisher<Void> mergeWith(String ... otherLogNames) {
        ArrayList<String> args = new ArrayList<String>(otherLogNames.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(otherLogNames));
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.PFMERGE, args.toArray());
    }
}

