/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.executor;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.Arrays;
import org.redisson.BaseRemoteService;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.executor.RemotePromise;
import org.redisson.misc.RPromise;
import org.redisson.remote.RemoteServiceRequest;

public class ExecutorRemoteService
extends BaseRemoteService {
    protected String terminationTopicName;
    protected String tasksCounterName;
    protected String statusName;

    public ExecutorRemoteService(Codec codec, RedissonClient redisson, String name, CommandExecutor commandExecutor) {
        super(codec, redisson, name, commandExecutor);
    }

    public void setTerminationTopicName(String terminationTopicName) {
        this.terminationTopicName = terminationTopicName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public void setTasksCounterName(String tasksCounterName) {
        this.tasksCounterName = tasksCounterName;
    }

    @Override
    protected final RFuture<Boolean> addAsync(RBlockingQueue<RemoteServiceRequest> requestQueue, RemoteServiceRequest request, RemotePromise<Object> result) {
        final RPromise<Boolean> promise = this.commandExecutor.getConnectionManager().newPromise();
        RFuture<Boolean> future = this.addAsync(requestQueue, request);
        result.setAddFuture(future);
        future.addListener(new FutureListener<Boolean>(){

            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                if (!((Boolean)future.getNow()).booleanValue()) {
                    promise.cancel(true);
                    return;
                }
                promise.trySuccess(true);
            }
        });
        return promise;
    }

    protected RFuture<Boolean> addAsync(RBlockingQueue<RemoteServiceRequest> requestQueue, RemoteServiceRequest request) {
        return this.commandExecutor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('exists', KEYS[2]) == 0 then redis.call('rpush', KEYS[3], ARGV[1]); redis.call('incr', KEYS[1]);return 1;end;return 0;", Arrays.asList(this.tasksCounterName, this.statusName, requestQueue.getName()), new Object[]{this.encode(request)});
    }

    @Override
    protected boolean remove(RBlockingQueue<RemoteServiceRequest> requestQueue, RemoteServiceRequest request) {
        byte[] encodedRequest = this.encode(request);
        return (Boolean)this.commandExecutor.evalWrite(this.name, LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('lrem', KEYS[1], 1, ARGV[1]) > 0 then if redis.call('decr', KEYS[2]) == 0 then redis.call('del', KEYS[2]);if redis.call('get', KEYS[3]) == ARGV[2] then redis.call('set', KEYS[3], ARGV[3]);redis.call('publish', KEYS[4], ARGV[3]);end;end;return 1;end;return 0;", Arrays.asList(requestQueue.getName(), this.tasksCounterName, this.statusName, this.terminationTopicName), encodedRequest, 1, 2);
    }
}

