/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonFairLock;
import org.redisson.api.RBlockingFairQueue;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.misc.RPromise;

public class RedissonBlockingFairQueue<V>
extends RedissonBlockingQueue<V>
implements RBlockingFairQueue<V> {
    private final RedissonFairLock fairLock;

    protected RedissonBlockingFairQueue(CommandExecutor commandExecutor, String name, UUID id) {
        super(commandExecutor, name);
        String lockName = this.prefixName("redisson_bfq_lock", name);
        this.fairLock = new RedissonFairLock(commandExecutor, lockName, id);
    }

    protected RedissonBlockingFairQueue(Codec codec, CommandExecutor commandExecutor, String name, UUID id) {
        super(codec, commandExecutor, name);
        String lockName = this.prefixName("redisson_bfq_lock", name);
        this.fairLock = new RedissonFairLock(commandExecutor, lockName, id);
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.DEL_OBJECTS, this.getName(), this.fairLock.getName(), this.fairLock.getThreadsQueueName(), this.fairLock.getTimeoutSetName());
    }

    @Override
    public V take() throws InterruptedException {
        this.fairLock.lockInterruptibly();
        try {
            Object v = super.take();
            return v;
        }
        finally {
            this.fairLock.unlock();
        }
    }

    @Override
    public RFuture<V> takeAsync() {
        final RPromise promise = this.newPromise();
        final long threadId = Thread.currentThread().getId();
        RFuture<Void> lockFuture = this.fairLock.lockAsync();
        lockFuture.addListener(new FutureListener<Void>(){

            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                final RFuture takeFuture = RedissonBlockingFairQueue.this.takeAsync();
                takeFuture.addListener(new FutureListener<V>(){

                    public void operationComplete(Future<V> future) throws Exception {
                        RFuture<Void> unlockFuture = RedissonBlockingFairQueue.this.fairLock.unlockAsync(threadId);
                        unlockFuture.addListener(new FutureListener<Void>(){

                            public void operationComplete(Future<Void> future) throws Exception {
                                if (!future.isSuccess()) {
                                    promise.tryFailure(future.cause());
                                    return;
                                }
                                if (!takeFuture.isSuccess()) {
                                    promise.tryFailure(takeFuture.cause());
                                    return;
                                }
                                promise.trySuccess(takeFuture.getNow());
                            }
                        });
                    }
                });
            }
        });
        return promise;
    }

    @Override
    public V poll() {
        if (this.fairLock.tryLock()) {
            try {
                Object v = super.poll();
                return v;
            }
            finally {
                this.fairLock.unlock();
            }
        }
        return null;
    }

    @Override
    public RFuture<V> pollAsync() {
        final RPromise promise = this.newPromise();
        final long threadId = Thread.currentThread().getId();
        RFuture<Boolean> tryLockFuture = this.fairLock.tryLockAsync();
        tryLockFuture.addListener(new FutureListener<Boolean>(){

            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                if (((Boolean)future.getNow()).booleanValue()) {
                    final RFuture pollFuture = RedissonBlockingFairQueue.super.pollAsync();
                    pollFuture.addListener(new FutureListener<V>(){

                        public void operationComplete(Future<V> future) throws Exception {
                            RFuture<Void> unlockFuture = RedissonBlockingFairQueue.this.fairLock.unlockAsync(threadId);
                            unlockFuture.addListener(new FutureListener<Void>(){

                                public void operationComplete(Future<Void> future) throws Exception {
                                    if (!future.isSuccess()) {
                                        promise.tryFailure(future.cause());
                                        return;
                                    }
                                    if (!pollFuture.isSuccess()) {
                                        promise.tryFailure(pollFuture.cause());
                                        return;
                                    }
                                    promise.trySuccess(pollFuture.getNow());
                                }
                            });
                        }
                    });
                } else {
                    promise.trySuccess(null);
                }
            }
        });
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        if (this.fairLock.tryLock(timeout, unit)) {
            try {
                long spentTime = System.currentTimeMillis() - startTime;
                long remainTime = unit.toMillis(timeout) - spentTime;
                if (remainTime > 0L) {
                    Object v = super.poll(remainTime, TimeUnit.MILLISECONDS);
                    return v;
                }
                V v = null;
                return v;
            }
            finally {
                this.fairLock.unlock();
            }
        }
        return null;
    }

    @Override
    public RFuture<V> pollAsync(final long timeout, final TimeUnit unit) {
        final long startTime = System.currentTimeMillis();
        final RPromise promise = this.newPromise();
        final long threadId = Thread.currentThread().getId();
        RFuture<Boolean> tryLockFuture = this.fairLock.tryLockAsync(timeout, unit);
        tryLockFuture.addListener(new FutureListener<Boolean>(){

            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                if (((Boolean)future.getNow()).booleanValue()) {
                    long spentTime = System.currentTimeMillis() - startTime;
                    long remainTime = unit.toMillis(timeout) - spentTime;
                    if (remainTime > 0L) {
                        final RFuture pollFuture = RedissonBlockingFairQueue.super.pollAsync(remainTime, TimeUnit.MILLISECONDS);
                        pollFuture.addListener(new FutureListener<V>(){

                            public void operationComplete(Future<V> future) throws Exception {
                                RFuture<Void> unlockFuture = RedissonBlockingFairQueue.this.fairLock.unlockAsync(threadId);
                                unlockFuture.addListener(new FutureListener<Void>(){

                                    public void operationComplete(Future<Void> future) throws Exception {
                                        if (!future.isSuccess()) {
                                            promise.tryFailure(future.cause());
                                            return;
                                        }
                                        if (!pollFuture.isSuccess()) {
                                            promise.tryFailure(pollFuture.cause());
                                            return;
                                        }
                                        promise.trySuccess(pollFuture.getNow());
                                    }
                                });
                            }
                        });
                    } else {
                        RFuture<Void> unlockFuture = RedissonBlockingFairQueue.this.fairLock.unlockAsync(threadId);
                        unlockFuture.addListener(new FutureListener<Void>(){

                            public void operationComplete(Future<Void> future) throws Exception {
                                if (!future.isSuccess()) {
                                    promise.tryFailure(future.cause());
                                    return;
                                }
                                promise.trySuccess(null);
                            }
                        });
                    }
                } else {
                    promise.trySuccess(null);
                }
            }
        });
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        if (this.fairLock.tryLock(timeout, unit)) {
            try {
                long spentTime = System.currentTimeMillis() - startTime;
                long remainTime = unit.toMillis(timeout) - spentTime;
                if (remainTime > 0L) {
                    Object v = super.pollLastAndOfferFirstTo(queueName, remainTime, TimeUnit.MILLISECONDS);
                    return v;
                }
                V v = null;
                return v;
            }
            finally {
                this.fairLock.unlock();
            }
        }
        return null;
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(final String queueName, final long timeout, final TimeUnit unit) {
        final long startTime = System.currentTimeMillis();
        final RPromise promise = this.newPromise();
        final long threadId = Thread.currentThread().getId();
        RFuture<Boolean> tryLockFuture = this.fairLock.tryLockAsync(timeout, unit);
        tryLockFuture.addListener(new FutureListener<Boolean>(){

            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                if (((Boolean)future.getNow()).booleanValue()) {
                    long spentTime = System.currentTimeMillis() - startTime;
                    long remainTime = unit.toMillis(timeout) - spentTime;
                    if (remainTime > 0L) {
                        final RFuture pollFuture = RedissonBlockingFairQueue.super.pollLastAndOfferFirstToAsync(queueName, remainTime, TimeUnit.MILLISECONDS);
                        pollFuture.addListener(new FutureListener<V>(){

                            public void operationComplete(Future<V> future) throws Exception {
                                RFuture<Void> unlockFuture = RedissonBlockingFairQueue.this.fairLock.unlockAsync(threadId);
                                unlockFuture.addListener(new FutureListener<Void>(){

                                    public void operationComplete(Future<Void> future) throws Exception {
                                        if (!future.isSuccess()) {
                                            promise.tryFailure(future.cause());
                                            return;
                                        }
                                        if (!pollFuture.isSuccess()) {
                                            promise.tryFailure(pollFuture.cause());
                                            return;
                                        }
                                        promise.trySuccess(pollFuture.getNow());
                                    }
                                });
                            }
                        });
                    } else {
                        RFuture<Void> unlockFuture = RedissonBlockingFairQueue.this.fairLock.unlockAsync(threadId);
                        unlockFuture.addListener(new FutureListener<Void>(){

                            public void operationComplete(Future<Void> future) throws Exception {
                                if (!future.isSuccess()) {
                                    promise.tryFailure(future.cause());
                                    return;
                                }
                                promise.trySuccess(null);
                            }
                        });
                    }
                } else {
                    promise.trySuccess(null);
                }
            }
        });
        return promise;
    }
}

