/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import lombok.EqualsAndHashCode;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.javac.Javac;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.JavacTreeMaker;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleEqualsAndHashCode
extends JavacAnnotationHandler<EqualsAndHashCode> {
    private static final String RESULT_NAME = "result";
    private static final String PRIME_NAME = "PRIME";

    public void checkForBogusFieldNames(JavacNode type, AnnotationValues<EqualsAndHashCode> annotation) {
        if (annotation.isExplicit("exclude")) {
            for (int i : JavacHandlerUtil.createListOfNonExistentFields(List.from(annotation.getInstance().exclude()), type, true, true)) {
                annotation.setWarning("exclude", "This field does not exist, or would have been excluded anyway.", i);
            }
        }
        if (annotation.isExplicit("of")) {
            for (int i : JavacHandlerUtil.createListOfNonExistentFields(List.from(annotation.getInstance().of()), type, false, false)) {
                annotation.setWarning("of", "This field does not exist.", i);
            }
        }
    }

    @Override
    public void handle(AnnotationValues<EqualsAndHashCode> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, EqualsAndHashCode.class);
        EqualsAndHashCode ann = annotation.getInstance();
        List<String> excludes = List.from(ann.exclude());
        List<String> includes = List.from(ann.of());
        JavacNode typeNode = (JavacNode)annotationNode.up();
        this.checkForBogusFieldNames(typeNode, annotation);
        Boolean callSuper = ann.callSuper();
        if (!annotation.isExplicit("callSuper")) {
            callSuper = null;
        }
        if (!annotation.isExplicit("exclude")) {
            excludes = null;
        }
        if (!annotation.isExplicit("of")) {
            includes = null;
        }
        if (excludes != null && includes != null) {
            excludes = null;
            annotation.setWarning("exclude", "exclude and of are mutually exclusive; the 'exclude' parameter will be ignored.");
        }
        JavacHandlerUtil.FieldAccess fieldAccess = ann.doNotUseGetters() ? JavacHandlerUtil.FieldAccess.PREFER_FIELD : JavacHandlerUtil.FieldAccess.GETTER;
        this.generateMethods(typeNode, annotationNode, excludes, includes, callSuper, true, fieldAccess);
    }

    public void generateEqualsAndHashCodeForType(JavacNode typeNode, JavacNode source) {
        if (JavacHandlerUtil.hasAnnotation(EqualsAndHashCode.class, typeNode)) {
            return;
        }
        this.generateMethods(typeNode, source, null, null, null, false, JavacHandlerUtil.FieldAccess.GETTER);
    }

    public void generateMethods(JavacNode typeNode, JavacNode source, List<String> excludes, List<String> includes, Boolean callSuper, boolean whineIfExists, JavacHandlerUtil.FieldAccess fieldAccess) {
        JCTree.JCVariableDecl fieldDecl;
        JCTree extending;
        boolean implicitCallSuper;
        boolean notAClass = true;
        if (typeNode.get() instanceof JCTree.JCClassDecl) {
            long flags = ((JCTree.JCClassDecl)typeNode.get()).mods.flags;
            boolean bl = notAClass = (flags & 0x6200L) != 0L;
        }
        if (notAClass) {
            source.addError("@EqualsAndHashCode is only supported on a class.");
            return;
        }
        boolean isDirectDescendantOfObject = true;
        boolean bl = implicitCallSuper = callSuper == null;
        if (callSuper == null) {
            try {
                callSuper = (boolean)((Boolean)EqualsAndHashCode.class.getMethod("callSuper", new Class[0]).getDefaultValue());
            }
            catch (Exception ignore) {
                throw new InternalError("Lombok bug - this cannot happen - can't find callSuper field in EqualsAndHashCode annotation.");
            }
        }
        if ((extending = Javac.getExtendsClause((JCTree.JCClassDecl)typeNode.get())) != null) {
            String p = extending.toString();
            boolean bl2 = isDirectDescendantOfObject = p.equals("Object") || p.equals("java.lang.Object");
        }
        if (isDirectDescendantOfObject && callSuper.booleanValue()) {
            source.addError("Generating equals/hashCode with a supercall to java.lang.Object is pointless.");
            return;
        }
        if (!isDirectDescendantOfObject && !callSuper.booleanValue() && implicitCallSuper) {
            source.addWarning("Generating equals/hashCode implementation but without a call to superclass, even though this class does not extend java.lang.Object. If this is intentional, add '@EqualsAndHashCode(callSuper=false)' to your type.");
        }
        ListBuffer<JavacNode> nodesForEquality = new ListBuffer<JavacNode>();
        if (includes != null) {
            for (JavacNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.FIELD) continue;
                fieldDecl = (JCTree.JCVariableDecl)child.get();
                if (!includes.contains(fieldDecl.name.toString())) continue;
                nodesForEquality.append(child);
            }
        } else {
            for (JavacNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.FIELD) continue;
                fieldDecl = (JCTree.JCVariableDecl)child.get();
                if ((fieldDecl.mods.flags & 8L) != 0L || (fieldDecl.mods.flags & 0x80L) != 0L || excludes != null && excludes.contains(fieldDecl.name.toString()) || fieldDecl.name.toString().startsWith("$")) continue;
                nodesForEquality.append(child);
            }
        }
        boolean isFinal = (((JCTree.JCClassDecl)typeNode.get()).mods.flags & 0x10L) != 0L;
        boolean needsCanEqual = !isFinal || !isDirectDescendantOfObject;
        JavacHandlerUtil.MemberExistsResult equalsExists = JavacHandlerUtil.methodExists("equals", typeNode, 1);
        JavacHandlerUtil.MemberExistsResult hashCodeExists = JavacHandlerUtil.methodExists("hashCode", typeNode, 0);
        JavacHandlerUtil.MemberExistsResult canEqualExists = JavacHandlerUtil.methodExists("canEqual", typeNode, 1);
        switch (Collections.max(Arrays.asList(equalsExists, hashCodeExists, canEqualExists))) {
            case EXISTS_BY_LOMBOK: {
                return;
            }
            case EXISTS_BY_USER: {
                if (whineIfExists) {
                    String msg = String.format("Not generating equals%s: A method with one of those names already exists. (Either all or none of these methods will be generated).", needsCanEqual ? ", hashCode and canEquals" : " and hashCode");
                    source.addWarning(msg);
                } else if (equalsExists == JavacHandlerUtil.MemberExistsResult.NOT_EXISTS || hashCodeExists == JavacHandlerUtil.MemberExistsResult.NOT_EXISTS) {
                    String msg = String.format("Not generating %s: One of equals, hashCode, and canEqual exists. You should either write all of these or none of these (in the latter case, lombok generates them).", equalsExists == JavacHandlerUtil.MemberExistsResult.NOT_EXISTS && hashCodeExists == JavacHandlerUtil.MemberExistsResult.NOT_EXISTS ? "equals and hashCode" : (equalsExists == JavacHandlerUtil.MemberExistsResult.NOT_EXISTS ? "equals" : "hashCode"));
                    source.addWarning(msg);
                }
                return;
            }
        }
        JCTree.JCMethodDecl equalsMethod = this.createEquals(typeNode, nodesForEquality.toList(), callSuper, fieldAccess, needsCanEqual, (JCTree)source.get());
        JavacHandlerUtil.injectMethod(typeNode, equalsMethod);
        if (needsCanEqual) {
            JCTree.JCMethodDecl canEqualMethod = this.createCanEqual(typeNode, (JCTree)source.get());
            JavacHandlerUtil.injectMethod(typeNode, canEqualMethod);
        }
        JCTree.JCMethodDecl hashCodeMethod = this.createHashCode(typeNode, nodesForEquality.toList(), callSuper, fieldAccess, (JCTree)source.get());
        JavacHandlerUtil.injectMethod(typeNode, hashCodeMethod);
    }

    public JCTree.JCMethodDecl createHashCode(JavacNode typeNode, List<JavacNode> fields, boolean callSuper, JavacHandlerUtil.FieldAccess fieldAccess, JCTree source) {
        JavacTreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCAnnotation overrideAnnotation = maker.Annotation(JavacHandlerUtil.genJavaLangTypeRef(typeNode, "Override"), List.<JCTree.JCExpression>nil());
        JCTree.JCModifiers mods = maker.Modifiers(1L, List.of(overrideAnnotation));
        JCTree.JCPrimitiveTypeTree returnType = maker.TypeIdent(Javac.CTC_INT);
        ListBuffer<JCTree.JCStatement> statements = new ListBuffer<JCTree.JCStatement>();
        Name primeName = typeNode.toName(PRIME_NAME);
        Name resultName = typeNode.toName(RESULT_NAME);
        long finalFlag = JavacHandlerUtil.addFinalIfNeeded(0L, typeNode.getContext());
        if (!fields.isEmpty() || callSuper) {
            statements.append(maker.VarDef(maker.Modifiers(finalFlag), primeName, maker.TypeIdent(Javac.CTC_INT), maker.Literal(277)));
        }
        statements.append(maker.VarDef(maker.Modifiers(0L), resultName, maker.TypeIdent(Javac.CTC_INT), maker.Literal(1)));
        if (callSuper) {
            JCTree.JCMethodInvocation callToSuper = maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select(maker.Ident(typeNode.toName("super")), typeNode.toName("hashCode")), List.<JCTree.JCExpression>nil());
            statements.append(this.createResultCalculation(typeNode, callToSuper));
        }
        Name dollar = typeNode.toName("$");
        block6: for (JavacNode fieldNode : fields) {
            JCTree.JCExpression fType = JavacHandlerUtil.getFieldType(fieldNode, fieldAccess);
            JCTree.JCExpression fieldAccessor = JavacHandlerUtil.createFieldAccessor(maker, fieldNode, fieldAccess);
            if (fType instanceof JCTree.JCPrimitiveTypeTree) {
                switch (((JCTree.JCPrimitiveTypeTree)fType).getPrimitiveTypeKind()) {
                    case BOOLEAN: {
                        statements.append(this.createResultCalculation(typeNode, maker.Conditional(fieldAccessor, maker.Literal(2609), maker.Literal(2591))));
                        continue block6;
                    }
                    case LONG: {
                        Name dollarFieldName = dollar.append(((JCTree.JCVariableDecl)fieldNode.get()).name);
                        statements.append(maker.VarDef(maker.Modifiers(finalFlag), dollarFieldName, maker.TypeIdent(Javac.CTC_LONG), fieldAccessor));
                        statements.append(this.createResultCalculation(typeNode, this.longToIntForHashCode(maker, maker.Ident(dollarFieldName), maker.Ident(dollarFieldName))));
                        continue block6;
                    }
                    case FLOAT: {
                        statements.append(this.createResultCalculation(typeNode, maker.Apply(List.<JCTree.JCExpression>nil(), JavacHandlerUtil.genJavaLangTypeRef(typeNode, "Float", "floatToIntBits"), List.of(fieldAccessor))));
                        continue block6;
                    }
                    case DOUBLE: {
                        Name dollarFieldName = dollar.append(((JCTree.JCVariableDecl)fieldNode.get()).name);
                        JCTree.JCMethodInvocation init = maker.Apply(List.<JCTree.JCExpression>nil(), JavacHandlerUtil.genJavaLangTypeRef(typeNode, "Double", "doubleToLongBits"), List.of(fieldAccessor));
                        statements.append(maker.VarDef(maker.Modifiers(finalFlag), dollarFieldName, maker.TypeIdent(Javac.CTC_LONG), init));
                        statements.append(this.createResultCalculation(typeNode, this.longToIntForHashCode(maker, maker.Ident(dollarFieldName), maker.Ident(dollarFieldName))));
                        continue block6;
                    }
                }
                statements.append(this.createResultCalculation(typeNode, fieldAccessor));
                continue;
            }
            if (fType instanceof JCTree.JCArrayTypeTree) {
                boolean multiDim = ((JCTree.JCArrayTypeTree)fType).elemtype instanceof JCTree.JCArrayTypeTree;
                boolean primitiveArray = ((JCTree.JCArrayTypeTree)fType).elemtype instanceof JCTree.JCPrimitiveTypeTree;
                boolean useDeepHC = multiDim || !primitiveArray;
                JCTree.JCExpression hcMethod = JavacHandlerUtil.chainDots(typeNode, "java", "util", "Arrays", useDeepHC ? "deepHashCode" : "hashCode");
                statements.append(this.createResultCalculation(typeNode, maker.Apply(List.<JCTree.JCExpression>nil(), hcMethod, List.of(fieldAccessor))));
                continue;
            }
            Name dollarFieldName = dollar.append(((JCTree.JCVariableDecl)fieldNode.get()).name);
            statements.append(maker.VarDef(maker.Modifiers(finalFlag), dollarFieldName, JavacHandlerUtil.genJavaLangTypeRef(typeNode, "Object"), fieldAccessor));
            JCTree.JCMethodInvocation hcCall = maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select(maker.Ident(dollarFieldName), typeNode.toName("hashCode")), List.<JCTree.JCExpression>nil());
            JCTree.JCBinary thisEqualsNull = maker.Binary(Javac.CTC_EQUAL, maker.Ident(dollarFieldName), maker.Literal(Javac.CTC_BOT, null));
            statements.append(this.createResultCalculation(typeNode, maker.Conditional(thisEqualsNull, maker.Literal(0), hcCall)));
        }
        statements.append(maker.Return(maker.Ident(resultName)));
        JCTree.JCBlock body = maker.Block(0L, statements.toList());
        return JavacHandlerUtil.recursiveSetGeneratedBy(maker.MethodDef(mods, typeNode.toName("hashCode"), returnType, List.<JCTree.JCTypeParameter>nil(), List.<JCTree.JCVariableDecl>nil(), List.<JCTree.JCExpression>nil(), body, null), source, typeNode.getContext());
    }

    public JCTree.JCExpressionStatement createResultCalculation(JavacNode typeNode, JCTree.JCExpression expr) {
        JavacTreeMaker maker = typeNode.getTreeMaker();
        Name resultName = typeNode.toName(RESULT_NAME);
        JCTree.JCBinary mult = maker.Binary(Javac.CTC_MUL, maker.Ident(resultName), maker.Ident(typeNode.toName(PRIME_NAME)));
        JCTree.JCBinary add = maker.Binary(Javac.CTC_PLUS, mult, expr);
        return maker.Exec(maker.Assign(maker.Ident(resultName), add));
    }

    public JCTree.JCExpression longToIntForHashCode(JavacTreeMaker maker, JCTree.JCExpression ref1, JCTree.JCExpression ref2) {
        JCTree.JCBinary shift = maker.Binary(Javac.CTC_UNSIGNED_SHIFT_RIGHT, ref1, maker.Literal(32));
        JCTree.JCBinary xorBits = maker.Binary(Javac.CTC_BITXOR, shift, ref2);
        return maker.TypeCast(maker.TypeIdent(Javac.CTC_INT), xorBits);
    }

    public JCTree.JCExpression createTypeReference(JavacNode type) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(type.getName());
        for (JavacNode tNode = (JavacNode)type.up(); tNode != null && tNode.getKind() == AST.Kind.TYPE; tNode = (JavacNode)tNode.up()) {
            list.add(tNode.getName());
        }
        Collections.reverse(list);
        JavacTreeMaker maker = type.getTreeMaker();
        JCTree.JCExpression chain = maker.Ident(type.toName((String)list.get(0)));
        for (int i = 1; i < list.size(); ++i) {
            chain = maker.Select(chain, type.toName((String)list.get(i)));
        }
        return chain;
    }

    public JCTree.JCMethodDecl createEquals(JavacNode typeNode, List<JavacNode> fields, boolean callSuper, JavacHandlerUtil.FieldAccess fieldAccess, boolean needsCanEqual, JCTree source) {
        JavacTreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCClassDecl type = (JCTree.JCClassDecl)typeNode.get();
        Name oName = typeNode.toName("o");
        Name otherName = typeNode.toName("other");
        Name thisName = typeNode.toName("this");
        JCTree.JCAnnotation overrideAnnotation = maker.Annotation(JavacHandlerUtil.genJavaLangTypeRef(typeNode, "Override"), List.<JCTree.JCExpression>nil());
        JCTree.JCModifiers mods = maker.Modifiers(1L, List.of(overrideAnnotation));
        JCTree.JCExpression objectType = JavacHandlerUtil.genJavaLangTypeRef(typeNode, "Object");
        JCTree.JCPrimitiveTypeTree returnType = maker.TypeIdent(Javac.CTC_BOOLEAN);
        long finalFlag = JavacHandlerUtil.addFinalIfNeeded(0L, typeNode.getContext());
        ListBuffer<JCTree.JCStatement> statements = new ListBuffer<JCTree.JCStatement>();
        List<JCTree.JCVariableDecl> params = List.of(maker.VarDef(maker.Modifiers(finalFlag | 0x200000000L), oName, objectType, null));
        statements.append(maker.If(maker.Binary(Javac.CTC_EQUAL, maker.Ident(oName), maker.Ident(thisName)), this.returnBool(maker, true), null));
        JCTree.JCUnary notInstanceOf = maker.Unary(Javac.CTC_NOT, maker.TypeTest(maker.Ident(oName), this.createTypeReference(typeNode)));
        statements.append(maker.If(notInstanceOf, this.returnBool(maker, false), null));
        if (!fields.isEmpty() || needsCanEqual) {
            JCTree.JCExpression selfType2;
            JCTree.JCExpression selfType1;
            ListBuffer<JCTree.JCWildcard> wildcards1 = new ListBuffer<JCTree.JCWildcard>();
            ListBuffer<JCTree.JCWildcard> wildcards2 = new ListBuffer<JCTree.JCWildcard>();
            for (int i = 0; i < type.typarams.length(); ++i) {
                wildcards1.append(maker.Wildcard(maker.TypeBoundKind(BoundKind.UNBOUND), null));
                wildcards2.append(maker.Wildcard(maker.TypeBoundKind(BoundKind.UNBOUND), null));
            }
            if (type.typarams.isEmpty()) {
                selfType1 = maker.Ident(type.name);
                selfType2 = maker.Ident(type.name);
            } else {
                selfType1 = maker.TypeApply(maker.Ident(type.name), wildcards1.toList());
                selfType2 = maker.TypeApply(maker.Ident(type.name), wildcards2.toList());
            }
            statements.append(maker.VarDef(maker.Modifiers(finalFlag), otherName, selfType1, maker.TypeCast(selfType2, maker.Ident(oName))));
        }
        if (needsCanEqual) {
            List<JCTree.JCExpression> exprNil = List.nil();
            JCTree.JCIdent thisRef = maker.Ident(thisName);
            JCTree.JCTypeCast castThisRef = maker.TypeCast(JavacHandlerUtil.genJavaLangTypeRef(typeNode, "Object"), thisRef);
            JCTree.JCMethodInvocation equalityCheck = maker.Apply(exprNil, maker.Select(maker.Ident(otherName), typeNode.toName("canEqual")), List.of(castThisRef));
            statements.append(maker.If(maker.Unary(Javac.CTC_NOT, equalityCheck), this.returnBool(maker, false), null));
        }
        if (callSuper) {
            JCTree.JCMethodInvocation callToSuper = maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select(maker.Ident(typeNode.toName("super")), typeNode.toName("equals")), List.of(maker.Ident(oName)));
            JCTree.JCUnary superNotEqual = maker.Unary(Javac.CTC_NOT, callToSuper);
            statements.append(maker.If(superNotEqual, this.returnBool(maker, false), null));
        }
        Name thisDollar = typeNode.toName("this$");
        Name otherDollar = typeNode.toName("other$");
        block5: for (JavacNode fieldNode : fields) {
            JCTree.JCExpression fType = JavacHandlerUtil.getFieldType(fieldNode, fieldAccess);
            JCTree.JCExpression thisFieldAccessor = JavacHandlerUtil.createFieldAccessor(maker, fieldNode, fieldAccess);
            JCTree.JCExpression otherFieldAccessor = JavacHandlerUtil.createFieldAccessor(maker, fieldNode, fieldAccess, maker.Ident(otherName));
            if (fType instanceof JCTree.JCPrimitiveTypeTree) {
                switch (((JCTree.JCPrimitiveTypeTree)fType).getPrimitiveTypeKind()) {
                    case FLOAT: {
                        statements.append(this.generateCompareFloatOrDouble(thisFieldAccessor, otherFieldAccessor, maker, typeNode, false));
                        continue block5;
                    }
                    case DOUBLE: {
                        statements.append(this.generateCompareFloatOrDouble(thisFieldAccessor, otherFieldAccessor, maker, typeNode, true));
                        continue block5;
                    }
                }
                statements.append(maker.If(maker.Binary(Javac.CTC_NOT_EQUAL, thisFieldAccessor, otherFieldAccessor), this.returnBool(maker, false), null));
                continue;
            }
            if (fType instanceof JCTree.JCArrayTypeTree) {
                boolean multiDim = ((JCTree.JCArrayTypeTree)fType).elemtype instanceof JCTree.JCArrayTypeTree;
                boolean primitiveArray = ((JCTree.JCArrayTypeTree)fType).elemtype instanceof JCTree.JCPrimitiveTypeTree;
                boolean useDeepEquals = multiDim || !primitiveArray;
                JCTree.JCExpression eqMethod = JavacHandlerUtil.chainDots(typeNode, "java", "util", "Arrays", useDeepEquals ? "deepEquals" : "equals");
                List<JCTree.JCExpression> args = List.of(thisFieldAccessor, otherFieldAccessor);
                statements.append(maker.If(maker.Unary(Javac.CTC_NOT, maker.Apply(List.<JCTree.JCExpression>nil(), eqMethod, args)), this.returnBool(maker, false), null));
                continue;
            }
            Name fieldName = ((JCTree.JCVariableDecl)fieldNode.get()).name;
            Name thisDollarFieldName = thisDollar.append(fieldName);
            Name otherDollarFieldName = otherDollar.append(fieldName);
            statements.append(maker.VarDef(maker.Modifiers(finalFlag), thisDollarFieldName, JavacHandlerUtil.genJavaLangTypeRef(typeNode, "Object"), thisFieldAccessor));
            statements.append(maker.VarDef(maker.Modifiers(finalFlag), otherDollarFieldName, JavacHandlerUtil.genJavaLangTypeRef(typeNode, "Object"), otherFieldAccessor));
            JCTree.JCBinary thisEqualsNull = maker.Binary(Javac.CTC_EQUAL, maker.Ident(thisDollarFieldName), maker.Literal(Javac.CTC_BOT, null));
            JCTree.JCBinary otherNotEqualsNull = maker.Binary(Javac.CTC_NOT_EQUAL, maker.Ident(otherDollarFieldName), maker.Literal(Javac.CTC_BOT, null));
            JCTree.JCMethodInvocation thisEqualsThat = maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select(maker.Ident(thisDollarFieldName), typeNode.toName("equals")), List.of(maker.Ident(otherDollarFieldName)));
            JCTree.JCConditional fieldsAreNotEqual = maker.Conditional(thisEqualsNull, otherNotEqualsNull, maker.Unary(Javac.CTC_NOT, thisEqualsThat));
            statements.append(maker.If(fieldsAreNotEqual, this.returnBool(maker, false), null));
        }
        statements.append(this.returnBool(maker, true));
        JCTree.JCBlock body = maker.Block(0L, statements.toList());
        return JavacHandlerUtil.recursiveSetGeneratedBy(maker.MethodDef(mods, typeNode.toName("equals"), returnType, List.<JCTree.JCTypeParameter>nil(), params, List.<JCTree.JCExpression>nil(), body, null), source, typeNode.getContext());
    }

    public JCTree.JCMethodDecl createCanEqual(JavacNode typeNode, JCTree source) {
        JavacTreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCModifiers mods = maker.Modifiers(1L, List.<JCTree.JCAnnotation>nil());
        JCTree.JCPrimitiveTypeTree returnType = maker.TypeIdent(Javac.CTC_BOOLEAN);
        Name canEqualName = typeNode.toName("canEqual");
        JCTree.JCExpression objectType = JavacHandlerUtil.genJavaLangTypeRef(typeNode, "Object");
        Name otherName = typeNode.toName("other");
        long flags = JavacHandlerUtil.addFinalIfNeeded(0x200000000L, typeNode.getContext());
        List<JCTree.JCVariableDecl> params = List.of(maker.VarDef(maker.Modifiers(flags), otherName, objectType, null));
        JCTree.JCBlock body = maker.Block(0L, List.of(maker.Return(maker.TypeTest(maker.Ident(otherName), this.createTypeReference(typeNode)))));
        return JavacHandlerUtil.recursiveSetGeneratedBy(maker.MethodDef(mods, canEqualName, returnType, List.<JCTree.JCTypeParameter>nil(), params, List.<JCTree.JCExpression>nil(), body, null), source, typeNode.getContext());
    }

    public JCTree.JCStatement generateCompareFloatOrDouble(JCTree.JCExpression thisDotField, JCTree.JCExpression otherDotField, JavacTreeMaker maker, JavacNode node, boolean isDouble) {
        JCTree.JCExpression clazz = JavacHandlerUtil.genJavaLangTypeRef(node, isDouble ? "Double" : "Float");
        List<JCTree.JCExpression> args = List.of(thisDotField, otherDotField);
        JCTree.JCBinary compareCallEquals0 = maker.Binary(Javac.CTC_NOT_EQUAL, maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select(clazz, node.toName("compare")), args), maker.Literal(0));
        return maker.If(compareCallEquals0, this.returnBool(maker, false), null);
    }

    public JCTree.JCStatement returnBool(JavacTreeMaker maker, boolean bool) {
        return maker.Return(maker.Literal(Javac.CTC_BOOLEAN, bool ? 1 : 0));
    }
}

