/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.FilterException;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityRoleFilter
implements MetadataFilter {
    private final Logger log = LoggerFactory.getLogger(EntityRoleFilter.class);
    private List<QName> roleWhiteList;
    private boolean removeRolelessEntityDescriptors;
    private boolean removeEmptyEntitiesDescriptors;
    private final QName extRoleDescriptor = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "RoleDescriptor");

    public EntityRoleFilter(List<QName> keptRoles) {
        this.roleWhiteList = new ArrayList<QName>();
        if (keptRoles != null) {
            this.roleWhiteList.addAll(keptRoles);
        }
        this.removeRolelessEntityDescriptors = true;
        this.removeEmptyEntitiesDescriptors = true;
    }

    public List<QName> getRoleWhiteList() {
        return Collections.unmodifiableList(this.roleWhiteList);
    }

    public boolean getRemoveRolelessEntityDescriptors() {
        return this.removeRolelessEntityDescriptors;
    }

    public void setRemoveRolelessEntityDescriptors(boolean remove) {
        this.removeRolelessEntityDescriptors = remove;
    }

    public boolean getRemoveEmptyEntitiesDescriptors() {
        return this.removeEmptyEntitiesDescriptors;
    }

    public void setRemoveEmptyEntitiesDescriptors(boolean remove) {
        this.removeEmptyEntitiesDescriptors = remove;
    }

    @Override
    public void doFilter(XMLObject metadata) throws FilterException {
        if (metadata == null) {
            return;
        }
        if (metadata instanceof EntitiesDescriptor) {
            this.filterEntitiesDescriptor((EntitiesDescriptor)metadata);
        } else {
            this.filterEntityDescriptor((EntityDescriptor)metadata);
        }
    }

    protected void filterEntitiesDescriptor(EntitiesDescriptor descriptor) throws FilterException {
        List<EntitiesDescriptor> entitiesDescriptors;
        List<EntityDescriptor> entityDescriptors = descriptor.getEntityDescriptors();
        if (entityDescriptors != null && !entityDescriptors.isEmpty()) {
            Iterator<EntityDescriptor> entityDescriptorsItr = entityDescriptors.iterator();
            while (entityDescriptorsItr.hasNext()) {
                List<RoleDescriptor> entityRoles;
                EntityDescriptor entityDescriptor = entityDescriptorsItr.next();
                this.filterEntityDescriptor(entityDescriptor);
                if (!this.getRemoveRolelessEntityDescriptors() || (entityRoles = entityDescriptor.getRoleDescriptors()) != null && !entityRoles.isEmpty()) continue;
                this.log.trace("Filtering out entity descriptor {} from entity group {}", (Object)entityDescriptor.getEntityID(), (Object)descriptor.getName());
                entityDescriptorsItr.remove();
            }
        }
        if ((entitiesDescriptors = descriptor.getEntitiesDescriptors()) != null && !entitiesDescriptors.isEmpty()) {
            Iterator<EntitiesDescriptor> entitiesDescriptorsItr = entitiesDescriptors.iterator();
            while (entitiesDescriptorsItr.hasNext()) {
                EntitiesDescriptor entitiesDescriptor = entitiesDescriptorsItr.next();
                this.filterEntitiesDescriptor(entitiesDescriptor);
                if (!this.getRemoveEmptyEntitiesDescriptors() || entitiesDescriptor.getEntityDescriptors() != null && !entitiesDescriptor.getEntityDescriptors().isEmpty() || entitiesDescriptor.getEntitiesDescriptors() != null && !entitiesDescriptor.getEntitiesDescriptors().isEmpty()) continue;
                this.log.trace("Filtering out entity descriptor {} from entity group {}", (Object)entitiesDescriptor.getName(), (Object)descriptor.getName());
                entitiesDescriptorsItr.remove();
            }
        }
    }

    protected void filterEntityDescriptor(EntityDescriptor descriptor) throws FilterException {
        List<RoleDescriptor> roles = descriptor.getRoleDescriptors();
        if (roles != null && !roles.isEmpty()) {
            Iterator<RoleDescriptor> rolesItr = roles.iterator();
            while (rolesItr.hasNext()) {
                QName roleName = this.getRoleName(rolesItr.next());
                if (this.roleWhiteList.contains(roleName)) continue;
                this.log.trace("Filtering out role {} from entity {}", (Object)roleName, (Object)descriptor.getEntityID());
                rolesItr.remove();
            }
        }
    }

    protected QName getRoleName(RoleDescriptor role) throws FilterException {
        QName roleName = role.getElementQName();
        if (this.extRoleDescriptor.equals(roleName) && (roleName = role.getSchemaType()) == null) {
            throw new FilterException("Role descriptor element was " + this.extRoleDescriptor + " but did not contain a schema type.  This is illegal.");
        }
        return roleName;
    }
}

