/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.helpers;

import info.aduna.iteration.CloseableIteration;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openrdf.model.BNode;
import org.openrdf.model.Model;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Modify;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.UnknownSailTransactionStateException;
import org.openrdf.sail.UpdateContext;
import org.openrdf.sail.helpers.SailBase;
import org.openrdf.sail.helpers.SailBaseIteration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SailConnectionBase
implements SailConnection {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SailBase sailBase;
    private volatile boolean isOpen;
    private volatile boolean txnActive;
    protected final ReentrantReadWriteLock connectionLock = new ReentrantReadWriteLock();
    protected final ReentrantLock updateLock = new ReentrantLock();
    private final List<SailBaseIteration> activeIterations = Collections.synchronizedList(new LinkedList());
    private final Throwable creatorTrace;
    private final Map<UpdateContext, Model> removed = new HashMap<UpdateContext, Model>();
    private final Map<UpdateContext, Model> added = new HashMap<UpdateContext, Model>();
    private final BNode wildContext = ValueFactoryImpl.getInstance().createBNode();

    private static boolean debugEnabled() {
        try {
            return System.getProperty("org.openrdf.repository.debug") != null;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public SailConnectionBase(SailBase sailBase) {
        this.sailBase = sailBase;
        this.isOpen = true;
        this.txnActive = false;
        this.creatorTrace = SailConnectionBase.debugEnabled() ? new Throwable() : null;
    }

    @Override
    public final boolean isOpen() throws SailException {
        return this.isOpen;
    }

    protected void verifyIsOpen() throws SailException {
        if (!this.isOpen) {
            throw new IllegalStateException("Connection has been closed");
        }
    }

    protected void verifyIsActive() throws SailException {
        if (!this.isActive()) {
            throw new SailException("No active transaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin() throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                if (this.isActive()) {
                    throw new SailException("A transaction is already active");
                }
                this.startTransactionInternal();
                this.txnActive = true;
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public boolean isActive() throws UnknownSailTransactionStateException {
        return this.transactionActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SailException {
        block19: {
            this.connectionLock.writeLock().lock();
            try {
                if (!this.isOpen) break block19;
                try {
                    while (true) {
                        SailBaseIteration ci = null;
                        List<SailBaseIteration> list = this.activeIterations;
                        synchronized (list) {
                            if (this.activeIterations.isEmpty()) {
                                break;
                            }
                            ci = this.activeIterations.remove(0);
                        }
                        try {
                            ci.forceClose();
                        }
                        catch (SailException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new SailException(e);
                        }
                    }
                    assert (this.activeIterations.isEmpty());
                    if (this.txnActive) {
                        this.logger.warn("Rolling back transaction due to connection close", new Throwable());
                        try {
                            this.rollbackInternal();
                        }
                        finally {
                            this.txnActive = false;
                        }
                    }
                    this.closeInternal();
                }
                finally {
                    this.isOpen = false;
                    this.sailBase.connectionClosed(this);
                }
            }
            finally {
                this.connectionLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.isOpen()) {
                if (this.creatorTrace != null) {
                    this.logger.warn("Closing connection due to garbage collection, connection was created in:", this.creatorTrace);
                }
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends BindingSet, QueryEvaluationException> closeableIteration = this.registerIteration(this.evaluateInternal(tupleExpr, dataset, bindings, includeInferred));
            return closeableIteration;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends Resource, SailException> closeableIteration = this.registerIteration(this.getContextIDsInternal());
            return closeableIteration;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends Statement, SailException> closeableIteration = this.registerIteration(this.getStatementsInternal(subj, pred, obj, includeInferred, contexts));
            return closeableIteration;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long size(Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            long l = this.sizeInternal(contexts);
            return l;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    protected final boolean transactionActive() {
        return this.txnActive;
    }

    @Deprecated
    protected void autoStartTransaction() throws SailException {
        this.verifyIsActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void commit() throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                if (this.txnActive) {
                    this.commitInternal();
                    this.txnActive = false;
                }
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void rollback() throws SailException {
        block9: {
            this.connectionLock.readLock().lock();
            try {
                this.verifyIsOpen();
                this.updateLock.lock();
                try {
                    if (!this.txnActive) break block9;
                    try {
                        this.rollbackInternal();
                    }
                    finally {
                        this.txnActive = false;
                    }
                }
                finally {
                    this.updateLock.unlock();
                }
            }
            finally {
                this.connectionLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                this.addStatementInternal(subj, pred, obj, contexts);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                this.removeStatementsInternal(subj, pred, obj, contexts);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startUpdate(UpdateContext op) throws SailException {
        if (op.getUpdateExpr() instanceof Modify) {
            Map<UpdateContext, Model> map = this.removed;
            synchronized (map) {
                assert (!this.removed.containsKey(op));
                this.removed.put(op, (Model)new LinkedHashModel());
            }
            map = this.added;
            synchronized (map) {
                assert (!this.added.containsKey(op));
                this.added.put(op, (Model)new LinkedHashModel());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatement(UpdateContext op, Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        Map<UpdateContext, Model> map = this.added;
        synchronized (map) {
            if (this.added.containsKey(op)) {
                this.added.get(op).add(subj, pred, obj, contexts);
            } else {
                this.addStatement(subj, pred, obj, contexts);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatement(UpdateContext op, Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        Map<UpdateContext, Model> map = this.removed;
        synchronized (map) {
            if (this.removed.containsKey(op)) {
                if (contexts != null && contexts.length == 0) {
                    contexts = new Resource[]{this.wildContext};
                }
                this.removed.get(op).add(subj, pred, obj, contexts);
            } else {
                this.removeStatements(subj, pred, obj, contexts);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endUpdate(UpdateContext op) throws SailException {
        Model model;
        Map<UpdateContext, Model> map = this.removed;
        synchronized (map) {
            model = this.removed.remove(op);
        }
        if (model != null) {
            for (Statement st : model) {
                Resource ctx = st.getContext();
                if (this.wildContext.equals((Object)ctx)) {
                    this.removeStatements(st.getSubject(), st.getPredicate(), st.getObject(), new Resource[0]);
                    continue;
                }
                this.removeStatements(st.getSubject(), st.getPredicate(), st.getObject(), ctx);
            }
        }
        Map<UpdateContext, Model> i$ = this.added;
        synchronized (i$) {
            model = this.added.remove(op);
        }
        if (model != null) {
            for (Statement st : model) {
                this.addStatement(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear(Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                this.clearInternal(contexts);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseableIteration<? extends Namespace, SailException> getNamespaces() throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends Namespace, SailException> closeableIteration = this.registerIteration(this.getNamespacesInternal());
            return closeableIteration;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getNamespace(String prefix) throws SailException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            String string = this.getNamespaceInternal(prefix);
            return string;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setNamespace(String prefix, String name) throws SailException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                this.setNamespaceInternal(prefix, name);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeNamespace(String prefix) throws SailException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                this.removeNamespaceInternal(prefix);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearNamespaces() throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.verifyIsActive();
                this.clearNamespacesInternal();
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    protected info.aduna.concurrent.locks.Lock getSharedConnectionLock() throws SailException {
        return new JavaLock(this.connectionLock.readLock());
    }

    protected info.aduna.concurrent.locks.Lock getExclusiveConnectionLock() throws SailException {
        return new JavaLock(this.connectionLock.writeLock());
    }

    @Deprecated
    protected info.aduna.concurrent.locks.Lock getTransactionLock() throws SailException {
        return new JavaLock(this.updateLock);
    }

    protected <T, E extends Exception> CloseableIteration<T, E> registerIteration(CloseableIteration<T, E> iter) {
        SailBaseIteration<T, E> result = new SailBaseIteration<T, E>(iter, this);
        this.activeIterations.add(result);
        return result;
    }

    protected void iterationClosed(SailBaseIteration iter) {
        this.activeIterations.remove((Object)iter);
    }

    protected abstract void closeInternal() throws SailException;

    protected abstract CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr var1, Dataset var2, BindingSet var3, boolean var4) throws SailException;

    protected abstract CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException;

    protected abstract CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource var1, URI var2, Value var3, boolean var4, Resource ... var5) throws SailException;

    protected abstract long sizeInternal(Resource ... var1) throws SailException;

    protected abstract void startTransactionInternal() throws SailException;

    protected abstract void commitInternal() throws SailException;

    protected abstract void rollbackInternal() throws SailException;

    protected abstract void addStatementInternal(Resource var1, URI var2, Value var3, Resource ... var4) throws SailException;

    protected abstract void removeStatementsInternal(Resource var1, URI var2, Value var3, Resource ... var4) throws SailException;

    protected abstract void clearInternal(Resource ... var1) throws SailException;

    protected abstract CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException;

    protected abstract String getNamespaceInternal(String var1) throws SailException;

    protected abstract void setNamespaceInternal(String var1, String var2) throws SailException;

    protected abstract void removeNamespaceInternal(String var1) throws SailException;

    protected abstract void clearNamespacesInternal() throws SailException;

    private static class JavaLock
    implements info.aduna.concurrent.locks.Lock {
        private final Lock javaLock;
        private boolean isActive = true;

        public JavaLock(Lock javaLock) {
            this.javaLock = javaLock;
            javaLock.lock();
        }

        @Override
        public synchronized boolean isActive() {
            return this.isActive;
        }

        @Override
        public synchronized void release() {
            if (this.isActive) {
                this.javaLock.unlock();
                this.isActive = false;
            }
        }
    }
}

