/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.federation;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.Iterations;
import info.aduna.iteration.SingletonIteration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.algebra.Service;
import org.openrdf.query.algebra.evaluation.federation.FederatedService;
import org.openrdf.query.algebra.evaluation.federation.JoinExecutorBase;
import org.openrdf.query.algebra.evaluation.federation.ServiceCrossProductIteration;
import org.openrdf.query.algebra.evaluation.federation.ServiceFallbackIteration;
import org.openrdf.query.algebra.evaluation.federation.ServiceJoinConversionIteration;
import org.openrdf.query.algebra.evaluation.iterator.CollectionIteration;
import org.openrdf.query.algebra.evaluation.iterator.SilentIteration;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sparql.SPARQLRepository;
import org.openrdf.repository.sparql.query.InsertBindingSetCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPARQLFederatedService
implements FederatedService {
    static final Logger logger = LoggerFactory.getLogger(SPARQLFederatedService.class);
    protected final SPARQLRepository rep;
    protected RepositoryConnection conn = null;

    public SPARQLFederatedService(String serviceUrl) {
        this.rep = new SPARQLRepository(serviceUrl);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(String sparqlQueryString, BindingSet bindings, String baseUri, FederatedService.QueryType type, Service service) throws QueryEvaluationException {
        try {
            if (type == FederatedService.QueryType.SELECT) {
                TupleQuery query = this.getConnection().prepareTupleQuery(QueryLanguage.SPARQL, sparqlQueryString, baseUri);
                for (Binding b : bindings) {
                    if (!service.getServiceVars().contains(b.getName())) continue;
                    query.setBinding(b.getName(), b.getValue());
                }
                TupleQueryResult res = query.evaluate();
                return new InsertBindingSetCursor((CloseableIteration)res, bindings);
            }
            if (type == FederatedService.QueryType.ASK) {
                BooleanQuery query = this.getConnection().prepareBooleanQuery(QueryLanguage.SPARQL, sparqlQueryString, baseUri);
                for (Binding b : bindings) {
                    if (!service.getServiceVars().contains(b.getName())) continue;
                    query.setBinding(b.getName(), b.getValue());
                }
                boolean exists = query.evaluate();
                if (exists) {
                    return new SingletonIteration((Object)bindings);
                }
                return new EmptyIteration();
            }
            throw new QueryEvaluationException("Unsupported QueryType: " + type.toString());
        }
        catch (MalformedQueryException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new QueryEvaluationException("SPARQLRepository for endpoint " + this.rep.toString() + " could not be initialized.", (Throwable)e);
        }
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Service service, CloseableIteration<BindingSet, QueryEvaluationException> bindings, String baseUri) throws QueryEvaluationException {
        int blockSize = 15;
        if (blockSize > 0) {
            return new BatchingServiceIteration(bindings, blockSize, service);
        }
        return this.evaluateInternal(service, bindings, service.getBaseURI());
    }

    protected CloseableIteration<BindingSet, QueryEvaluationException> evaluateInternal(Service service, CloseableIteration<BindingSet, QueryEvaluationException> bindings, String baseUri) throws QueryEvaluationException {
        LinkedList<BindingSet> allBindings = new LinkedList<BindingSet>();
        while (bindings.hasNext()) {
            allBindings.add((BindingSet)bindings.next());
        }
        if (allBindings.size() == 0) {
            return new EmptyIteration();
        }
        HashSet<String> projectionVars = new HashSet<String>(service.getServiceVars());
        projectionVars.removeAll(((BindingSet)allBindings.get(0)).getBindingNames());
        Object result = null;
        try {
            if (allBindings.size() == 1) {
                String queryString = service.getQueryString(projectionVars);
                result = this.evaluate(queryString, (BindingSet)allBindings.get(0), baseUri, FederatedService.QueryType.SELECT, service);
                result = service.isSilent() ? new SilentIteration((CloseableIteration<BindingSet, QueryEvaluationException>)result) : result;
                return result;
            }
            projectionVars.add("__rowIdx");
            String queryString = service.getQueryString(projectionVars);
            List<String> relevantBindingNames = this.getRelevantBindingNames(allBindings, service.getServiceVars());
            if (relevantBindingNames.size() != 0) {
                queryString = queryString + this.buildVALUESClause(allBindings, relevantBindingNames);
            }
            TupleQuery query = this.getConnection().prepareTupleQuery(QueryLanguage.SPARQL, queryString, baseUri);
            TupleQueryResult res = null;
            try {
                query.setMaxQueryTime(60);
                res = query.evaluate();
            }
            catch (QueryEvaluationException q) {
                this.closeQuietly(res);
                String preparedQuery = service.getQueryString(projectionVars);
                result = new ServiceFallbackIteration(service, preparedQuery, allBindings, this);
                result = service.isSilent() ? new SilentIteration((CloseableIteration<BindingSet, QueryEvaluationException>)result) : result;
                return result;
            }
            result = relevantBindingNames.size() == 0 ? new ServiceCrossProductIteration((CloseableIteration<BindingSet, QueryEvaluationException>)res, allBindings) : new ServiceJoinConversionIteration((CloseableIteration<BindingSet, QueryEvaluationException>)res, allBindings);
            result = service.isSilent() ? new SilentIteration((CloseableIteration<BindingSet, QueryEvaluationException>)result) : result;
            return result;
        }
        catch (RepositoryException e) {
            Iterations.closeCloseable(result);
            if (service.isSilent()) {
                return new CollectionIteration(allBindings);
            }
            throw new QueryEvaluationException("SPARQLRepository for endpoint " + this.rep.toString() + " could not be initialized.", (Throwable)e);
        }
        catch (MalformedQueryException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
        catch (QueryEvaluationException e) {
            Iterations.closeCloseable(result);
            if (service.isSilent()) {
                return new CollectionIteration(allBindings);
            }
            throw e;
        }
        catch (RuntimeException e) {
            Iterations.closeCloseable(result);
            if (service.isSilent()) {
                return new CollectionIteration(allBindings);
            }
            throw e;
        }
    }

    @Override
    public void initialize() throws RepositoryException {
        this.rep.initialize();
    }

    private void closeQuietly(TupleQueryResult res) {
        try {
            if (res != null) {
                res.close();
            }
        }
        catch (Exception e) {
            logger.debug("Could not close connection properly: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void shutdown() throws RepositoryException {
        if (this.conn != null) {
            this.conn.close();
        }
        this.rep.shutDown();
    }

    protected RepositoryConnection getConnection() throws RepositoryException {
        if (this.conn == null) {
            this.conn = this.rep.getConnection();
        }
        return this.conn;
    }

    private List<String> getRelevantBindingNames(List<BindingSet> bindings, Set<String> serviceVars) {
        ArrayList<String> relevantBindingNames = new ArrayList<String>(5);
        for (String bName : bindings.get(0).getBindingNames()) {
            if (!serviceVars.contains(bName)) continue;
            relevantBindingNames.add(bName);
        }
        return relevantBindingNames;
    }

    private String buildVALUESClause(List<BindingSet> bindings, List<String> relevantBindingNames) throws QueryEvaluationException {
        StringBuilder sb = new StringBuilder();
        sb.append(" VALUES (?__rowIdx");
        for (String bName : relevantBindingNames) {
            sb.append(" ?").append(bName);
        }
        sb.append(") { ");
        int rowIdx = 0;
        for (BindingSet b : bindings) {
            sb.append(" (");
            sb.append("\"").append(rowIdx++).append("\" ");
            for (String bName : relevantBindingNames) {
                this.appendValueAsString(sb, b.getValue(bName)).append(" ");
            }
            sb.append(")");
        }
        sb.append(" }");
        return sb.toString();
    }

    protected StringBuilder appendValueAsString(StringBuilder sb, Value value) {
        if (value == null) {
            return sb.append("UNDEF");
        }
        if (value instanceof URI) {
            return SPARQLFederatedService.appendURI(sb, (URI)value);
        }
        if (value instanceof Literal) {
            return SPARQLFederatedService.appendLiteral(sb, (Literal)value);
        }
        throw new RuntimeException("Type not supported: " + value.getClass().getCanonicalName());
    }

    protected static StringBuilder appendURI(StringBuilder sb, URI uri) {
        sb.append("<").append(uri.stringValue()).append(">");
        return sb;
    }

    protected static StringBuilder appendLiteral(StringBuilder sb, Literal lit) {
        sb.append('\"');
        sb.append(lit.getLabel().replace("\"", "\\\""));
        sb.append('\"');
        if (lit.getLanguage() != null) {
            sb.append('@');
            sb.append(lit.getLanguage());
        }
        if (lit.getDatatype() != null) {
            sb.append("^^<");
            sb.append(lit.getDatatype().stringValue());
            sb.append('>');
        }
        return sb;
    }

    private class BatchingServiceIteration
    extends JoinExecutorBase<BindingSet> {
        private final int blockSize;
        private final Service service;

        public BatchingServiceIteration(CloseableIteration<BindingSet, QueryEvaluationException> inputBindings, int blockSize, Service service) throws QueryEvaluationException {
            super(inputBindings, null, EmptyBindingSet.getInstance());
            this.blockSize = blockSize;
            this.service = service;
            this.run();
        }

        @Override
        protected void handleBindings() throws Exception {
            while (!this.closed && this.leftIter.hasNext()) {
                ArrayList<Object> blockBindings = new ArrayList<Object>(this.blockSize);
                for (int i = 0; i < this.blockSize && this.leftIter.hasNext(); ++i) {
                    blockBindings.add(this.leftIter.next());
                }
                CollectionIteration materializedIter = new CollectionIteration(blockBindings);
                this.addResult(SPARQLFederatedService.this.evaluateInternal(this.service, (CloseableIteration<BindingSet, QueryEvaluationException>)materializedIter, this.service.getBaseURI()));
            }
        }
    }
}

