/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.AbstractModel;

class UnmodifiableModel
extends AbstractModel {
    private static final long serialVersionUID = 6335569454318096059L;
    private final Model model;

    public UnmodifiableModel(Model delegate) {
        this.model = delegate;
    }

    @Override
    public Map<String, String> getNamespaces() {
        return Collections.unmodifiableMap(this.model.getNamespaces());
    }

    @Override
    public String getNamespace(String prefix) {
        return this.model.getNamespace(prefix);
    }

    @Override
    public String setNamespace(String prefix, String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String removeNamespace(String prefix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Resource subj, URI pred, Value obj, Resource ... contexts) {
        return this.model.contains(subj, pred, obj, contexts);
    }

    @Override
    public boolean add(Resource subj, URI pred, Value obj, Resource ... contexts) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Resource subj, URI pred, Value obj, Resource ... contexts) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Model filter(Resource subj, URI pred, Value obj, Resource ... contexts) {
        return this.model.filter(subj, pred, obj, contexts).unmodifiable();
    }

    @Override
    public Iterator<Statement> iterator() {
        return Collections.unmodifiableSet(this.model).iterator();
    }

    @Override
    public int size() {
        return this.model.size();
    }

    @Override
    public void removeTermIteration(Iterator<Statement> iter, Resource subj, URI pred, Value obj, Resource ... contexts) {
        throw new UnsupportedOperationException();
    }
}

