/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.weixin.session.memory;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.nutz.weixin.session.memory.MemorySessionManager;
import org.nutz.weixin.spi.WxSession;

public class MemoryWxSession
implements WxSession {
    protected String id;
    protected long createTime;
    protected long lastAccessedTime;
    protected int maxInactiveInterval;
    protected Map<String, Object> attrs = new LinkedHashMap<String, Object>();
    protected boolean valid = true;
    protected MemorySessionManager manager;

    protected MemoryWxSession() {
    }

    public MemoryWxSession(String id, MemorySessionManager manager) {
        this();
        this.id = id;
        this.manager = manager;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getCreationTime() {
        return this.createTime;
    }

    @Override
    public Object getAttribute(String name) {
        this.checkValid();
        return this.attrs.get(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.checkValid();
        this.attrs.put(name, value);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        this.checkValid();
        return Collections.enumeration(this.attrs.keySet());
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.checkValid();
        this.maxInactiveInterval = interval;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    protected void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    protected void setAttrs(Map<String, Object> attrs) {
        this.attrs = attrs;
    }

    @Override
    public void invalidate() {
        this.valid = false;
        this.manager.remove(this.id);
    }

    protected void checkValid() {
        if (!this.valid) {
            throw new IllegalStateException(String.format("session(%s) had been invalidate", this.id));
        }
    }
}

