/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.weixin.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.nutz.castor.Castors;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.Sender;
import org.nutz.http.sender.FilePostSender;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.ContinueLoop;
import org.nutz.lang.Each;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.LoopException;
import org.nutz.lang.Strings;
import org.nutz.lang.Xmls;
import org.nutz.lang.random.R;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.NutResource;
import org.nutz.weixin.bean.WxArticle;
import org.nutz.weixin.bean.WxGroup;
import org.nutz.weixin.bean.WxKfAccount;
import org.nutz.weixin.bean.WxMassArticle;
import org.nutz.weixin.bean.WxMenu;
import org.nutz.weixin.bean.WxOutMsg;
import org.nutz.weixin.bean.WxPayCoupon;
import org.nutz.weixin.bean.WxPayRedPack;
import org.nutz.weixin.bean.WxPayRedPackGroup;
import org.nutz.weixin.bean.WxPayRefund;
import org.nutz.weixin.bean.WxPayRefundQuery;
import org.nutz.weixin.bean.WxPayTransfers;
import org.nutz.weixin.bean.WxPayUnifiedOrder;
import org.nutz.weixin.bean.WxTemplateData;
import org.nutz.weixin.impl.AbstractWxApi2;
import org.nutz.weixin.spi.WXAccountApi;
import org.nutz.weixin.spi.WxResp;
import org.nutz.weixin.util.WxPaySSL;
import org.nutz.weixin.util.WxPaySign;
import org.nutz.weixin.util.Wxs;

public class WxApi2Impl
extends AbstractWxApi2 {
    private static final Log log = Logs.get().setTag("weixin");
    public static final String ShakeUrlBase = "https://api.weixin.qq.com/shakearound";

    public WxApi2Impl() {
    }

    public WxApi2Impl(String token, String appid, String appsecret, String openid, String encodingAesKey) {
        super(token, appid, appsecret, openid, encodingAesKey);
    }

    @Override
    public WxResp send(WxOutMsg out) {
        if (out.getFromUserName() == null) {
            out.setFromUserName(this.openid);
        }
        String str = Wxs.asJson(out);
        if (Wxs.DEV_MODE) {
            log.debug((Object)("api out msg>\n" + str));
        }
        return this.call("/message/custom/send", Request.METHOD.POST, str);
    }

    @Override
    public List<String> getcallbackip() {
        return this.get("/getcallbackip", new String[0]).getList("ip_list", String.class);
    }

    @Override
    public WxResp user_info(String openid, String lang) {
        return this.get("/user/info", "openid", openid, "lang", lang);
    }

    @Override
    public WxResp user_info_updatemark(String openid, String remark) {
        return this.postJson("/user/info/updateremark", "openid", openid, "remark", remark);
    }

    @Override
    public void user_get(Each<String> each) {
        String next_openid = null;
        WxResp map = null;
        int count = 0;
        int total = 0;
        int index = 0;
        block4: while ((count = ((Number)(map = next_openid == null ? this.call("/user/get", Request.METHOD.GET, null) : this.call("/user/get?next_openid=" + next_openid, Request.METHOD.GET, null)).get("count")).intValue()) >= 1) {
            total = ((Number)map.get("total")).intValue();
            next_openid = Strings.sNull((Object)map.get("next_openid"));
            if (next_openid.length() == 0) {
                next_openid = null;
            }
            List openids = (List)((Map)map.get("data")).get("openid");
            Iterator iterator = openids.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block4;
                String openid = (String)iterator.next();
                try {
                    each.invoke(index, (Object)openid, total);
                }
                catch (ExitLoop e) {
                    return;
                }
                catch (ContinueLoop e) {
                    continue;
                }
                catch (LoopException e) {
                    throw e;
                }
                ++index;
            }
            break;
        }
        return;
    }

    @Override
    public WxResp groups_create(WxGroup group) {
        return this.postJson("/groups/create", "group", group);
    }

    @Override
    public WxResp groups_get() {
        return this.call("/groups/get", Request.METHOD.GET, null);
    }

    @Override
    public WxResp groups_getid(String openid) {
        return this.postJson("/groups/getid", "openid", openid);
    }

    @Override
    public WxResp groups_update(WxGroup group) {
        return this.postJson("/groups/update", "group", group);
    }

    @Override
    public WxResp groups_member_update(String openid, String to_groupid) {
        return this.postJson("/groups/member/update", "openid", openid, "to_groupid", to_groupid);
    }

    @Override
    public WxResp qrcode_create(Object scene_id, int expire_seconds) {
        NutMap scene;
        NutMap params = new NutMap();
        if (expire_seconds > 0) {
            params.put((Object)"expire_seconds", (Object)expire_seconds);
            if (scene_id instanceof Number) {
                params.put((Object)"action_name", (Object)"QR_SCENE");
                scene = Lang.map((String)"scene_id", (Object)Castors.me().castTo(scene_id, Integer.class));
            } else {
                params.put((Object)"action_name", (Object)"QR_STR_SCENE");
                scene = Lang.map((String)"scene_str", (Object)scene_id.toString());
            }
        } else if (scene_id instanceof Number) {
            params.put((Object)"action_name", (Object)"QR_LIMIT_SCENE");
            scene = Lang.map((String)"scene_id", (Object)Castors.me().castTo(scene_id, Integer.class));
        } else {
            params.put((Object)"action_name", (Object)"QR_LIMIT_STR_SCENE");
            scene = Lang.map((String)"scene_str", (Object)scene_id.toString());
        }
        params.put((Object)"action_info", (Object)Lang.map((String)"scene", (Object)scene));
        return this.postJson("/qrcode/create", params);
    }

    @Override
    public String qrcode_show(String ticket) {
        return "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=" + ticket;
    }

    @Override
    public String shorturl(String long_url) {
        return this.postJson("/shorturl", new NutMap().setv("long_url", (Object)long_url).setv("action", (Object)"long2short")).getString("short_url");
    }

    @Override
    public WxResp template_api_set_industry(String industry_id1, String industry_id2) {
        return this.postJson("/template/api_set_industry", "industry_id1", industry_id1, "industry_id2", industry_id2);
    }

    @Override
    public WxResp template_api_add_template(String template_id_short) {
        return this.postJson("/template/api_add_template", "template_id_short", template_id_short);
    }

    @Override
    public WxResp template_api_del_template(String template_id) {
        return this.postJson("/template/del_private_template", "template_id", template_id);
    }

    @Override
    public WxResp template_send(String touser, String template_id, String url, Map<String, WxTemplateData> data) {
        return this.postJson("/message/template/send", "touser", touser, "template_id", template_id, "url", url, "data", data);
    }

    @Override
    public WxResp template_send(String touser, String template_id, String url, Map<String, Object> miniprogram, Map<String, WxTemplateData> data) {
        return this.postJson("/message/template/send", "touser", touser, "template_id", template_id, "url", url, miniprogram, miniprogram, "data", data);
    }

    @Override
    public WxResp menu_create(NutMap map) {
        return this.postJson("/menu/create", map);
    }

    @Override
    public WxResp menu_create(List<WxMenu> button) {
        return this.postJson("/menu/create", "button", button);
    }

    @Override
    public WxResp menu_get() {
        return this.call("/menu/get", Request.METHOD.GET, null);
    }

    @Override
    public WxResp menu_delete() {
        return this.call("/menu/delete", Request.METHOD.GET, null);
    }

    @Override
    public WxResp media_upload(String type, File f) {
        if (type == null) {
            throw new NullPointerException("media type is NULL");
        }
        if (f == null) {
            throw new NullPointerException("meida file is NULL");
        }
        String url = String.format("http://api.weixin.qq.com/cgi-bin/media/upload?access_token=%s&type=%s", this.getAccessToken(), type);
        Request req = Request.create((String)url, (Request.METHOD)Request.METHOD.POST);
        req.getParams().put("media", f);
        Response resp = new FilePostSender(req).send();
        if (!resp.isOK()) {
            throw new IllegalStateException("media upload file, resp code=" + resp.getStatus());
        }
        return (WxResp)((Object)Json.fromJson(WxResp.class, (Reader)resp.getReader("UTF-8")));
    }

    @Override
    public NutResource media_get(String mediaId) {
        String url = String.format("http://file.api.weixin.qq.com/cgi-bin/media/get?access_token=%s&media_id=%s", this.getAccessToken(), mediaId);
        Response resp = Sender.create((Request)Request.create((String)url, (Request.METHOD)Request.METHOD.GET)).send();
        if (!resp.isOK()) {
            throw new IllegalStateException("download media file, resp code=" + resp.getStatus());
        }
        String disposition = resp.getHeader().get("Content-disposition");
        return new WxResource(disposition, resp.getStream());
    }

    @Override
    public WxResp mass_uploadnews(List<WxArticle> articles) {
        return this.postJson("/message/mass/uploadnews", "articles", articles);
    }

    public WxResp _mass_send(NutMap filter, List<String> to_user, String touser, WxOutMsg msg) {
        NutMap params = new NutMap();
        if (filter != null) {
            params.setv("filter", (Object)filter);
        } else if (to_user != null) {
            params.setv("touser", to_user);
        } else {
            params.put((Object)"touser", (Object)touser);
        }
        String tp = msg.getMsgType();
        if ("text".equals(tp)) {
            params.put((Object)"text", (Object)new NutMap().setv("content", (Object)msg.getContent()));
        } else if ("image".equals(tp) || "voice".equals(tp) || "mpnews".equals(tp)) {
            params.put((Object)tp, (Object)new NutMap().setv("media_id", (Object)msg.getMedia_id()));
        } else if ("video".equals(tp)) {
            NutMap tm = new NutMap();
            tm.put((Object)"media_id", (Object)msg.getMedia_id());
            tm.put((Object)"thumb_media_id", (Object)msg.getVideo().getThumb_media_id());
            tm.put((Object)"title", (Object)msg.getVideo().getTitle());
            tm.put((Object)"description", (Object)msg.getVideo().getDescription());
            params.put((Object)tp, (Object)tm);
        } else if ("music".equals(tp)) {
            NutMap tm = new NutMap();
            tm.put((Object)"musicurl", (Object)msg.getMusic().getMusicUrl());
            tm.put((Object)"hqmusicurl", (Object)msg.getMusic().getHQMusicUrl());
            tm.put((Object)"thumb_media_id", (Object)msg.getMusic().getThumbMediaId());
            tm.put((Object)"title", (Object)msg.getMusic().getTitle());
            tm.put((Object)"description", (Object)msg.getMusic().getDescription());
            params.put((Object)tp, (Object)tm);
        } else if ("news".equals(tp)) {
            params.put((Object)"news", msg.getArticles());
        } else if ("wxcard".equals(tp)) {
            params.put((Object)"wxcard", (Object)new NutMap().setv("card_id", (Object)msg.getCard().getId()).setv("card_ext", (Object)msg.getCard().getExt()));
        } else {
            params.put((Object)msg.getMsgType(), (Object)new NutMap().setv("media_id", (Object)msg.getMedia_id()));
        }
        params.setv("msgtype", (Object)msg.getMsgType());
        if (msg.getKfAccount() != null) {
            params.setv("customservice", (Object)new NutMap().setv("kf_account", (Object)msg.getKfAccount().getAccount()));
        }
        if (filter != null) {
            return this.postJson("/message/mass/sendall", params);
        }
        if (to_user != null) {
            return this.postJson("/message/mass/send", params);
        }
        return this.postJson("/message/mass/preview", params);
    }

    @Override
    public WxResp mass_sendall(boolean is_to_all, String group_id, WxOutMsg msg) {
        NutMap filter = new NutMap();
        filter.put((Object)"is_to_all", (Object)is_to_all);
        if (!is_to_all) {
            filter.put((Object)"group_id", (Object)group_id);
        }
        return this._mass_send(filter, null, null, msg);
    }

    @Override
    public WxResp mass_send(List<String> to_user, WxOutMsg msg) {
        return this._mass_send(null, to_user, null, msg);
    }

    @Override
    public WxResp mass_del(String msg_id) {
        return this.postJson("/message/mass/del", "msg_id", msg_id);
    }

    @Override
    public WxResp mass_get(String msg_id) {
        return this.postJson("/message/mass/get", "msg_id", msg_id);
    }

    @Override
    public WxResp mass_preview(String touser, WxOutMsg msg) {
        return this._mass_send(null, null, touser, msg);
    }

    @Override
    public WxResp applyId(int quantity, String apply_reason, String comment, int poi_id) {
        return this.postJson("https://api.weixin.qq.com/shakearound/device/applyid", "quantity", quantity, "apply_reason", apply_reason, "comment", comment);
    }

    @Override
    public WxResp applyStatus(String apply_id) {
        return this.postJson("https://api.weixin.qq.com/shakearound/device/applystatus", "apply_id", apply_id);
    }

    @Override
    public WxResp update(int device_id, String comment) {
        NutMap params = new NutMap();
        params.put((Object)"device_identifier", (Object)new NutMap().setv("device_id", (Object)device_id));
        params.put((Object)"comment", (Object)comment);
        return this.postJson("https://api.weixin.qq.com/shakearound/device/update", params);
    }

    @Override
    public WxResp update(String uuid, int major, int minor, String comment) {
        NutMap params = new NutMap();
        params.put((Object)"device_identifier", (Object)new NutMap().setv("uuid", (Object)uuid).setv("major", (Object)major).setv("minor", (Object)minor));
        params.put((Object)"comment", (Object)comment);
        return this.postJson("https://api.weixin.qq.com/shakearound/device/update", params);
    }

    @Override
    public WxResp bindLocation(int device_id, int poi_id) {
        NutMap params = new NutMap();
        params.put((Object)"device_identifier", (Object)new NutMap().setv("device_id", (Object)device_id));
        params.put((Object)"poi_id", (Object)poi_id);
        return this.postJson("https://api.weixin.qq.com/shakearound/device/bindlocation", params);
    }

    @Override
    public WxResp bindLocation(String uuid, int major, int minor, int poi_id) {
        NutMap params = new NutMap();
        params.put((Object)"device_identifier", (Object)new NutMap().setv("uuid", (Object)uuid).setv("major", (Object)major).setv("minor", (Object)minor));
        params.put((Object)"poi_id", (Object)poi_id);
        return this.postJson("https://api.weixin.qq.com/shakearound/device/bindlocation", params);
    }

    @Override
    public WxResp search(int device_id) {
        NutMap params = new NutMap();
        params.put((Object)"device_identifier", (Object)new NutMap().setv("device_id", (Object)device_id));
        return this.postJson("https://api.weixin.qq.com/shakearound/device/search", params);
    }

    @Override
    public WxResp search(String uuid, int major, int minor) {
        NutMap params = new NutMap();
        params.put((Object)"device_identifier", (Object)new NutMap().setv("uuid", (Object)uuid).setv("major", (Object)major).setv("minor", (Object)minor));
        return this.postJson("https://api.weixin.qq.com/shakearound/device/search", params);
    }

    @Override
    public WxResp search(int begin, int count) {
        return this.postJson("https://api.weixin.qq.com/shakearound/device/search", "begin", begin, "count", count);
    }

    @Override
    public WxResp search(int apply_id, int begin, int count) {
        return this.postJson("https://api.weixin.qq.com/shakearound/device/search", "apply_id", apply_id, "begin", begin, "count", count);
    }

    @Override
    public WxResp getShakeInfo(String ticket, int need_poi) {
        return this.postJson("https://api.weixin.qq.com/shakearound/user/getshakeinfo", "ticket", ticket, "need_poi", need_poi);
    }

    @Override
    public WxResp createQRTicket(long expire, WXAccountApi.Type type, int id) {
        NutMap json = NutMap.NEW();
        json.put((Object)"expire_seconds", (Object)expire);
        json.put((Object)"action_name", (Object)type.getValue());
        NutMap action = NutMap.NEW();
        NutMap scene = NutMap.NEW();
        scene.put((Object)"scene_id", (Object)id);
        action.put((Object)"scene", (Object)scene);
        json.put((Object)"action_info", (Object)action);
        return this.postJson("/qrcode/create", json);
    }

    @Override
    public WxResp createQRTicket(long expire, WXAccountApi.Type type, String str) {
        NutMap json = NutMap.NEW();
        json.put((Object)"expire_seconds", (Object)expire);
        json.put((Object)"action_name", (Object)type.getValue());
        NutMap action = NutMap.NEW();
        NutMap scene = NutMap.NEW();
        scene.put((Object)"scene_str", (Object)str);
        action.put((Object)"scene", (Object)scene);
        json.put((Object)"action_info", (Object)action);
        return this.postJson("/qrcode/create", json);
    }

    @Override
    public String qrURL(String ticket) {
        return String.format("https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=%s", ticket);
    }

    @Override
    public WxResp get_all_private_template() {
        return this.postJson("/template/get_all_private_template", NutMap.NEW());
    }

    @Override
    public WxResp get_industry() {
        return this.postJson("/template/get_industry", NutMap.NEW());
    }

    @Override
    public WxResp add_news(WxMassArticle ... news) {
        return this.postJson("/material/add_news", "articles", Arrays.asList(news));
    }

    @Override
    public WxResp uploadimg(File f) {
        if (f == null) {
            throw new NullPointerException("meida file is NULL");
        }
        String url = String.format("https://api.weixin.qq.com/cgi-bin/media/uploadimg?access_token=%s", this.getAccessToken());
        Request req = Request.create((String)url, (Request.METHOD)Request.METHOD.POST);
        req.getParams().put("media", f);
        Response resp = new FilePostSender(req).send();
        if (!resp.isOK()) {
            throw new IllegalStateException("uploadimg, resp code=" + resp.getStatus());
        }
        return (WxResp)((Object)Json.fromJson(WxResp.class, (Reader)resp.getReader("UTF-8")));
    }

    @Override
    public WxResp uploadnews(List<WxMassArticle> articles) {
        return this.call("/media/uploadnews", Request.METHOD.POST, Json.toJson((Object)new NutMap().setv("articles", articles)));
    }

    @Override
    public WxResp add_material(String type, File f) {
        if (f == null) {
            throw new NullPointerException("meida file is NULL");
        }
        String url = String.format("https://api.weixin.qq.com/cgi-bin/material/add_material?access_token=%s&type=%s", this.getAccessToken(), type);
        Request req = Request.create((String)url, (Request.METHOD)Request.METHOD.POST);
        req.getParams().put("media", f);
        Response resp = new FilePostSender(req).send();
        if (!resp.isOK()) {
            throw new IllegalStateException("add_material, resp code=" + resp.getStatus());
        }
        return (WxResp)((Object)Json.fromJson(WxResp.class, (Reader)resp.getReader("UTF-8")));
    }

    @Override
    public WxResp add_video(File f, String title, String introduction) {
        if (f == null) {
            throw new NullPointerException("meida file is NULL");
        }
        String url = String.format("https://api.weixin.qq.com/cgi-bin/material/add_material?type=video&access_token=%s", this.getAccessToken());
        Request req = Request.create((String)url, (Request.METHOD)Request.METHOD.POST);
        req.getParams().put("media", f);
        req.getParams().put("description", Json.toJson((Object)new NutMap().setv("title", (Object)title).setv("introduction", (Object)introduction), (JsonFormat)JsonFormat.compact().setQuoteName(true)));
        Response resp = new FilePostSender(req).send();
        if (!resp.isOK()) {
            throw new IllegalStateException("add_material, resp code=" + resp.getStatus());
        }
        return (WxResp)((Object)Json.fromJson(WxResp.class, (Reader)resp.getReader("UTF-8")));
    }

    @Override
    public NutResource get_material(String media_id) {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/material/get_material?access_token=%s", this.getAccessToken());
        Request req = Request.create((String)url, (Request.METHOD)Request.METHOD.POST);
        NutMap body = new NutMap();
        body.put((Object)"media_id", (Object)media_id);
        req.setData(Json.toJson((Object)body));
        Response resp = Sender.create((Request)req).send();
        if (!resp.isOK()) {
            throw new IllegalStateException("download media file, resp code=" + resp.getStatus());
        }
        String disposition = resp.getHeader().get("Content-disposition");
        return new WxResource(disposition, resp.getStream());
    }

    @Override
    public List<WxArticle> get_material_news(String media_id) {
        try {
            NutMap re = (NutMap)Json.fromJson(NutMap.class, (Reader)this.get_material(media_id).getReader());
            ArrayList<WxArticle> list = new ArrayList<WxArticle>();
            for (Object obj : (List)re.getAs("news_item", List.class)) {
                list.add((WxArticle)Lang.map2Object((Map)((Map)obj), WxArticle.class));
            }
            return list;
        }
        catch (Exception e) {
            throw Lang.wrapThrow((Throwable)e);
        }
    }

    @Override
    public WxResp get_material_video(String media_id) {
        return this.postJson("/material/get_material", new NutMap().setv("media_id", (Object)media_id));
    }

    @Override
    public WxResp del_material(String media_id) {
        return this.postJson("/material/del_material", new NutMap().setv("media_id", (Object)media_id));
    }

    @Override
    public WxResp update_material(String media_id, int index, WxArticle article) {
        return this.postJson("/material/update_news", new NutMap().setv("media_id", (Object)media_id).setv("index", (Object)index).setv("articles", (Object)article));
    }

    @Override
    public WxResp get_materialcount() {
        return this.get("/material/get_materialcount", new String[0]);
    }

    @Override
    public WxResp batchget_material(String type, int offset, int count) {
        return this.postJson("/material/batchget_material", new NutMap().setv("type", (Object)type).setv("offset", (Object)offset).setv("count", (Object)count));
    }

    @Override
    public List<WxKfAccount> getkflist() {
        return this.get("/customservice/getkflist", new String[0]).check().getTo("kf_list", WxKfAccount.class);
    }

    @Override
    public List<WxKfAccount> getonlinekflist() {
        return this.get("/customservice/getonlinekflist", new String[0]).check().getTo("kf_online_list", WxKfAccount.class);
    }

    @Override
    public WxResp kfaccount_add(String kf_account, String nickname, String password) {
        return this.postJson("/customservice/kfaccount/add", "kf_account", kf_account, "nickname", nickname, "password", password);
    }

    @Override
    public WxResp kfaccount_update(String kf_account, String nickname, String password) {
        return this.postJson("/customservice/kfaccount/update", "kf_account", kf_account, "nickname", nickname, "password", password);
    }

    @Override
    public WxResp kfaccount_uploadheadimg(String kf_account, File f) {
        if (f == null) {
            throw new NullPointerException("meida file is NULL");
        }
        String url = String.format("https://api.weixin.qq.com/customservice/kfaccount/uploadheadimg?access_token=%s", this.getAccessToken());
        Request req = Request.create((String)url, (Request.METHOD)Request.METHOD.POST);
        req.getParams().put("media", f);
        Response resp = new FilePostSender(req).send();
        if (!resp.isOK()) {
            throw new IllegalStateException("uploadimg, resp code=" + resp.getStatus());
        }
        return (WxResp)((Object)Json.fromJson(WxResp.class, (Reader)resp.getReader("UTF-8")));
    }

    @Override
    public WxResp kfaccount_del(String kf_account) {
        return this.postJson("/customservice/kfaccount/del", "kf_account", kf_account);
    }

    @Override
    public NutMap postPay(String url, String key, Map<String, Object> params) {
        params.remove("sign");
        String sign = WxPaySign.createSign(key, params);
        params.put("sign", sign);
        Request req = Request.create((String)url, (Request.METHOD)Request.METHOD.POST);
        req.setData(Xmls.mapToXml(params));
        Response resp = Sender.create((Request)req).send();
        if (!resp.isOK()) {
            throw new IllegalStateException("postPay, resp code=" + resp.getStatus());
        }
        return Xmls.xmlToMap((String)resp.getContent("UTF-8"));
    }

    @Override
    public NutMap postPay(String url, String key, Map<String, Object> params, File file, String password) {
        SSLSocketFactory sslSocketFactory;
        params.remove("sign");
        String sign = WxPaySign.createSign(key, params);
        params.put("sign", sign);
        Request req = Request.create((String)url, (Request.METHOD)Request.METHOD.POST);
        req.setData(Xmls.mapToXml(params));
        Sender sender = Sender.create((Request)req);
        try {
            sslSocketFactory = WxPaySSL.buildSSL(file, password);
        }
        catch (Exception e) {
            throw Lang.wrapThrow((Throwable)e);
        }
        sender.setSSLSocketFactory(sslSocketFactory);
        Response resp = sender.send();
        if (!resp.isOK()) {
            throw new IllegalStateException("postPay with SSL, resp code=" + resp.getStatus());
        }
        return Xmls.xmlToMap((String)resp.getContent("UTF-8"));
    }

    @Override
    public NutMap pay_unifiedorder(String key, WxPayUnifiedOrder wxPayUnifiedOrder) {
        String url = "https://api.mch.weixin.qq.com/pay/unifiedorder";
        Map params = Lang.obj2map((Object)wxPayUnifiedOrder);
        return this.postPay(url, key, params);
    }

    @Override
    public NutMap pay_jsapi(String key, WxPayUnifiedOrder wxPayUnifiedOrder) {
        NutMap map = this.pay_unifiedorder(key, wxPayUnifiedOrder);
        NutMap params = NutMap.NEW();
        params.put((Object)"appId", (Object)wxPayUnifiedOrder.getAppid());
        params.put((Object)"timeStamp", (Object)String.valueOf((int)(System.currentTimeMillis() / 1000L)));
        params.put((Object)"nonceStr", (Object)R.UU32());
        params.put((Object)"package", (Object)("prepay_id=" + map.getString("prepay_id")));
        params.put((Object)"signType", (Object)"MD5");
        String sign = WxPaySign.createSign(key, (Map<String, Object>)params);
        params.put((Object)"paySign", (Object)sign);
        return params;
    }

    @Override
    public NutMap pay_transfers(String key, WxPayTransfers wxPayTransfers, File file, String password) {
        String url = "https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers";
        Map params = Lang.obj2map((Object)wxPayTransfers);
        return this.postPay(url, key, params, file, password);
    }

    @Override
    public NutMap send_redpack(String key, WxPayRedPack wxRedPack, File file, String password) {
        String url = "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendredpack";
        Map params = Lang.obj2map((Object)wxRedPack);
        return this.postPay(url, key, params, file, password);
    }

    @Override
    public NutMap send_redpackgroup(String key, WxPayRedPackGroup wxRedPackGroup, File file, String password) {
        String url = "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendgroupredpack";
        Map params = Lang.obj2map((Object)wxRedPackGroup);
        return this.postPay(url, key, params, file, password);
    }

    @Override
    public NutMap send_coupon(String key, WxPayCoupon wxPayCoupon, File file, String password) {
        String url = "https://api.mch.weixin.qq.com/mmpaymkttransfers/send_coupon";
        Map params = Lang.obj2map((Object)wxPayCoupon);
        return this.postPay(url, key, params, file, password);
    }

    @Override
    public NutMap pay_refund(String key, WxPayRefund wxPayRefund, File file, String password) {
        String url = "https://api.mch.weixin.qq.com/secapi/pay/refund";
        Map params = Lang.obj2map((Object)wxPayRefund);
        return this.postPay(url, key, params, file, password);
    }

    @Override
    public NutMap pay_refundquery(String key, WxPayRefundQuery wxPayRefundQuery) {
        String url = "https://api.mch.weixin.qq.com/pay/refundquery";
        Map params = Lang.obj2map((Object)wxPayRefundQuery);
        return this.postPay(url, key, params);
    }

    static class WxResource
    extends NutResource {
        String disposition;
        InputStream ins;

        public WxResource(String disposition, InputStream ins) {
            this.disposition = disposition;
            this.ins = ins;
        }

        public String getName() {
            if (this.disposition == null) {
                return "file.data";
            }
            for (String str : this.disposition.split(";")) {
                if (!(str = str.trim()).startsWith("filename=")) continue;
                if ((str = str.substring("filename=".length())).startsWith("\"")) {
                    str = str.substring(1);
                }
                if (str.endsWith("\"")) {
                    str = str.substring(0, str.length() - 1);
                }
                return str.trim().intern();
            }
            return "file.data";
        }

        public InputStream getInputStream() throws IOException {
            return this.ins;
        }
    }
}

