/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.weixin.at.impl;

import org.nutz.dao.Dao;
import org.nutz.integration.jedis.JedisAgent;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.lang.Strings;
import org.nutz.weixin.at.impl.DaoAccessTokenStore;
import org.nutz.weixin.at.impl.JedisAgenAccessTokenStore;
import org.nutz.weixin.at.impl.MemoryAccessTokenStore;
import org.nutz.weixin.at.impl.RedisAccessTokenStore;
import org.nutz.weixin.spi.WxAccessTokenStore;
import redis.clients.jedis.JedisPool;

public class WxAccessTokenStoreFactory {
    public static WxAccessTokenStore make(String type, Ioc ioc) {
        if (Strings.isBlank((CharSequence)type) || "memory".equals(type)) {
            return new MemoryAccessTokenStore();
        }
        if ("dao".equals(type)) {
            return new DaoAccessTokenStore((Dao)ioc.get(Dao.class));
        }
        if ("jedisPool".equals(type)) {
            PropertiesProxy conf = (PropertiesProxy)ioc.get(PropertiesProxy.class, "conf");
            return new RedisAccessTokenStore(conf.get("weixin.redis.key"), (JedisPool)ioc.get(JedisPool.class));
        }
        if ("jedis".equals(type)) {
            PropertiesProxy conf = (PropertiesProxy)ioc.get(PropertiesProxy.class, "conf");
            return new JedisAgenAccessTokenStore(conf.get("weixin.redis.key"), (JedisAgent)ioc.get(JedisAgent.class));
        }
        throw new RuntimeException("unsupport type=" + type);
    }
}

