/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.weixin.at.impl;

import java.util.HashMap;
import java.util.Map;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.weixin.at.WxAccessToken;
import org.nutz.weixin.spi.WxAccessTokenStore;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisAccessTokenStore
implements WxAccessTokenStore {
    private static final Log log = Logs.get();
    protected String tokenKey = "wxmp:access_token";
    protected JedisPool jedisPool;

    public RedisAccessTokenStore() {
    }

    public RedisAccessTokenStore(String tokenKey, JedisPool jedisPool) {
        if (!Strings.isBlank((CharSequence)tokenKey)) {
            this.tokenKey = tokenKey;
        }
        this.jedisPool = jedisPool;
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    public String getTokenKey() {
        return this.tokenKey;
    }

    public void setTokenKey(String tokenKey) {
        this.tokenKey = tokenKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WxAccessToken get() {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (this.tokenKey == null) {
                throw new RuntimeException("Redis token key should not be null!");
            }
            Map hash = jedis.hgetAll(this.tokenKey);
            if (Lang.isEmpty((Object)hash)) {
                log.warnf("could not find a valid token in redis with key [%s]", new Object[]{this.tokenKey});
                WxAccessToken wxAccessToken = null;
                return wxAccessToken;
            }
            WxAccessToken at = new WxAccessToken();
            at.setToken((String)hash.get("token"));
            at.setLastCacheTimeMillis(Long.valueOf((String)hash.get("lastCacheMillis")));
            at.setExpires(Integer.valueOf((String)hash.get("expires")));
            log.debugf("wx access_token fetched from redis with the key [%s] : \n %s", new Object[]{this.tokenKey, Json.toJson((Object)at, (JsonFormat)JsonFormat.nice())});
            WxAccessToken wxAccessToken = at;
            return wxAccessToken;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            jedis.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String token, int expires, long lastCacheTimeMillis) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (this.tokenKey == null) {
                throw new RuntimeException("Redis access_token key should not be null!");
            }
            HashMap<String, String> hash = new HashMap<String, String>();
            hash.put("token", token);
            hash.put("lastCacheMillis", String.valueOf(lastCacheTimeMillis));
            hash.put("expires", String.valueOf(expires));
            String result = jedis.hmset(this.tokenKey, hash);
            log.infof("A new wx access_token was generated and stored to redis with the key [%s] , redis return code : %s", new Object[]{this.tokenKey, result});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            jedis.close();
        }
    }
}

