/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.weixin.at.impl;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import org.nutz.integration.jedis.JedisAgent;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.weixin.at.WxAccessToken;
import org.nutz.weixin.spi.WxAccessTokenStore;
import redis.clients.jedis.Jedis;

public class JedisAgenAccessTokenStore
implements WxAccessTokenStore {
    protected String tokenKey = "wxmp:access_token";
    protected JedisAgent jedisAgent;

    public JedisAgenAccessTokenStore(String tokenKey, JedisAgent jedisAgent) {
        if (!Strings.isBlank((CharSequence)tokenKey)) {
            this.tokenKey = tokenKey;
        }
        this.jedisAgent = jedisAgent;
    }

    @Override
    public WxAccessToken get() {
        Map map;
        Jedis jedis = null;
        try {
            jedis = this.jedisAgent.getResource();
            map = jedis.hgetAll(this.tokenKey);
        }
        finally {
            Streams.safeClose((Closeable)jedis);
        }
        if (map == null || map.isEmpty()) {
            return null;
        }
        return (WxAccessToken)Lang.map2Object((Map)map, WxAccessToken.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String token, int expires, long lastCacheTimeMillis) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("token", token);
        map.put("expires", "" + expires);
        map.put("lastCacheTimeMillis", "" + lastCacheTimeMillis);
        Jedis jedis = null;
        try {
            jedis = this.jedisAgent.getResource();
            jedis.hmset(this.tokenKey, map);
        }
        finally {
            Streams.safeClose((Closeable)jedis);
        }
    }

    public void setTokenKey(String tokenKey) {
        this.tokenKey = tokenKey;
    }
}

