/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.weixin.at.impl;

import java.util.Map;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Record;
import org.nutz.dao.sql.Sql;
import org.nutz.weixin.at.WxAccessToken;
import org.nutz.weixin.spi.WxAccessTokenStore;

public class DaoAccessTokenStore
implements WxAccessTokenStore {
    private Dao dao;
    private Map<String, Object> params;
    private String tableAccessToken = "access_token";
    private String tableAccessTokenExpires = "access_token_expires";
    private String tableAccessTokenLastat = "access_token_lastat";
    private String fetch = "select access_token,access_token_expires,access_token_lastat from wx_config where id=@id";
    private String update = "update wx_config set access_token=@access_token, access_token_expires=@access_token_expires, access_token_lastat=@access_token_lastat where id=@id";

    public DaoAccessTokenStore() {
    }

    public DaoAccessTokenStore(Dao dao) {
        this.dao = dao;
    }

    @Override
    public WxAccessToken get() {
        Sql sql = Sqls.fetchRecord((String)this.fetch);
        if (this.params != null) {
            sql.params().putAll(this.params);
        }
        this.dao.execute(sql);
        Record record = (Record)sql.getObject(Record.class);
        WxAccessToken at = new WxAccessToken();
        at.setToken(record.getString(this.tableAccessToken));
        at.setExpires(record.getInt(this.tableAccessTokenExpires));
        at.setLastCacheTimeMillis(record.getLong(this.tableAccessTokenLastat));
        return at;
    }

    @Override
    public void save(String token, int time, long lastCacheTimeMillis) {
        Sql sql = Sqls.create((String)this.update);
        if (this.params != null) {
            sql.params().putAll(this.params);
        }
        sql.params().set(this.tableAccessToken, (Object)token);
        sql.params().set(this.tableAccessTokenExpires, (Object)time);
        sql.params().set(this.tableAccessTokenLastat, (Object)lastCacheTimeMillis);
        this.dao.execute(sql);
    }

    public Dao getDao() {
        return this.dao;
    }

    public void setDao(Dao dao) {
        this.dao = dao;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public String getTableAccessToken() {
        return this.tableAccessToken;
    }

    public void setTableAccessToken(String tableAccessToken) {
        this.tableAccessToken = tableAccessToken;
    }

    public String getTableAccessTokenExpires() {
        return this.tableAccessTokenExpires;
    }

    public void setTableAccessTokenExpires(String tableAccessTokenExpires) {
        this.tableAccessTokenExpires = tableAccessTokenExpires;
    }

    public String getTableAccessTokenLastat() {
        return this.tableAccessTokenLastat;
    }

    public void setTableAccessTokenLastat(String tableAccessTokenLastat) {
        this.tableAccessTokenLastat = tableAccessTokenLastat;
    }

    public String getFetch() {
        return this.fetch;
    }

    public void setFetch(String fetch) {
        this.fetch = fetch;
    }

    public String getUpdate() {
        return this.update;
    }

    public void setUpdate(String update) {
        this.update = update;
    }
}

