/*
 * Decompiled with CFR 0.152.
 */
package ninja.validation;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.io.Serializable;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import javax.validation.MessageInterpolator;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.ConstraintDescriptor;
import ninja.Context;
import ninja.Result;
import ninja.i18n.Lang;
import ninja.validation.ConstraintViolation;
import ninja.validation.FieldViolation;
import ninja.validation.IsDate;
import ninja.validation.IsEnum;
import ninja.validation.IsFloat;
import ninja.validation.IsInteger;
import ninja.validation.Length;
import ninja.validation.Matches;
import ninja.validation.NumberValue;
import ninja.validation.Required;
import ninja.validation.Validation;
import ninja.validation.Validator;

public class Validators {
    private static String fieldKey(String fieldName, String configuredFieldKey) {
        if (configuredFieldKey.length() > 0) {
            return configuredFieldKey;
        }
        return fieldName;
    }

    public static class EnumValidator
    implements Validator<String> {
        private final IsEnum isEnum;

        public EnumValidator(IsEnum anEnum) {
            this.isEnum = anEnum;
        }

        @Override
        public void validate(String value, String field, Context context) {
            if (value != null) {
                Enum<?>[] values;
                for (Enum<?> v : values = this.isEnum.enumClass().getEnumConstants()) {
                    if (!(this.isEnum.caseSensitive() ? v.name().equals(value) : v.name().equalsIgnoreCase(value))) continue;
                    return;
                }
                context.getValidation().addFieldViolation(field, ConstraintViolation.createForFieldWithDefault("validation.is.enum.violation", field, "{0} is not a valid enum constant", value, this.isEnum.enumClass().getName()));
            }
        }

        @Override
        public Class<String> getValidatedType() {
            return String.class;
        }
    }

    public static class NumberValidator
    implements Validator<Number> {
        private final NumberValue number;

        public NumberValidator(NumberValue number) {
            this.number = number;
        }

        @Override
        public void validate(Number value, String field, Context context) {
            if (value != null) {
                if (this.number.max() != Double.MAX_VALUE && value.doubleValue() > this.number.max()) {
                    context.getValidation().addFieldViolation(field, ConstraintViolation.createForFieldWithDefault(this.number.maxKey(), Validators.fieldKey(field, this.number.fieldKey()), this.number.maxMessage(), this.number.max(), value));
                } else if (this.number.min() != -1.0 && value.doubleValue() < this.number.min()) {
                    context.getValidation().addFieldViolation(field, ConstraintViolation.createForFieldWithDefault(this.number.minKey(), Validators.fieldKey(field, this.number.fieldKey()), this.number.minMessage(), this.number.min(), value));
                }
            }
        }

        @Override
        public Class<Number> getValidatedType() {
            return Number.class;
        }
    }

    public static class MatchesValidator
    implements Validator<String> {
        private final Matches matches;
        private final Pattern pattern;

        public MatchesValidator(Matches matches) {
            this.matches = matches;
            this.pattern = Pattern.compile(matches.regexp());
        }

        @Override
        public void validate(String value, String field, Context context) {
            if (value != null && !this.pattern.matcher(value).matches()) {
                context.getValidation().addFieldViolation(field, ConstraintViolation.createForFieldWithDefault(this.matches.key(), Validators.fieldKey(field, this.matches.fieldKey()), this.matches.message(), this.matches.regexp(), value));
            }
        }

        @Override
        public Class<String> getValidatedType() {
            return String.class;
        }
    }

    public static class DateValidator
    implements Validator<String> {
        private final IsDate isDate;

        public DateValidator(IsDate aDate) {
            this.isDate = aDate;
        }

        @Override
        public void validate(String value, String field, Context context) {
            if (value != null) {
                try {
                    Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    context.getValidation().addFieldViolation(field, ConstraintViolation.createForFieldWithDefault(this.isDate.key(), Validators.fieldKey(field, this.isDate.fieldKey()), this.isDate.message(), value));
                }
            }
        }

        @Override
        public Class<String> getValidatedType() {
            return String.class;
        }
    }

    public static class FloatValidator
    implements Validator<String> {
        private final IsFloat isFloat;

        public FloatValidator(IsFloat aFloat) {
            this.isFloat = aFloat;
        }

        @Override
        public void validate(String value, String field, Context context) {
            if (value != null) {
                try {
                    Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    context.getValidation().addFieldViolation(field, ConstraintViolation.createForFieldWithDefault(this.isFloat.key(), Validators.fieldKey(field, this.isFloat.fieldKey()), this.isFloat.message(), value));
                }
            }
        }

        @Override
        public Class<String> getValidatedType() {
            return String.class;
        }
    }

    public static class IntegerValidator
    implements Validator<String> {
        private final IsInteger isInteger;

        public IntegerValidator(IsInteger integer) {
            this.isInteger = integer;
        }

        @Override
        public void validate(String value, String field, Context context) {
            if (value != null) {
                try {
                    Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    context.getValidation().addFieldViolation(field, ConstraintViolation.createForFieldWithDefault(this.isInteger.key(), Validators.fieldKey(field, this.isInteger.fieldKey()), this.isInteger.message(), value));
                }
            }
        }

        @Override
        public Class<String> getValidatedType() {
            return String.class;
        }
    }

    public static class LengthValidator
    implements Validator<String> {
        private final Length length;

        public LengthValidator(Length length) {
            this.length = length;
        }

        @Override
        public void validate(String value, String field, Context context) {
            if (value != null) {
                if (this.length.max() != -1 && value.length() > this.length.max()) {
                    context.getValidation().addFieldViolation(field, ConstraintViolation.createForFieldWithDefault(this.length.maxKey(), Validators.fieldKey(field, this.length.fieldKey()), this.length.maxMessage(), this.length.max(), value));
                } else if (this.length.min() != -1 && value.length() < this.length.min()) {
                    context.getValidation().addFieldViolation(field, ConstraintViolation.createForFieldWithDefault(this.length.minKey(), Validators.fieldKey(field, this.length.fieldKey()), this.length.minMessage(), this.length.min(), value));
                }
            }
        }

        @Override
        public Class<String> getValidatedType() {
            return String.class;
        }
    }

    public static class RequiredValidator
    implements Validator<Object> {
        private final Required required;

        public RequiredValidator(Required required) {
            this.required = required;
        }

        @Override
        public void validate(Object value, String field, Context context) {
            if (value == null) {
                context.getValidation().addFieldViolation(field, ConstraintViolation.createForFieldWithDefault(this.required.key(), Validators.fieldKey(field, this.required.fieldKey()), this.required.message(), new Object[0]));
            }
        }

        @Override
        public Class<Object> getValidatedType() {
            return Object.class;
        }
    }

    public static class JSRValidator
    implements Validator<Object> {
        private final Lang requestLanguage;

        @Inject
        public JSRValidator(Lang requestLanguage) {
            this.requestLanguage = requestLanguage;
        }

        @Override
        public void validate(Object value, String field, Context context) {
            if (value != null) {
                ValidatorFactory validatorFactory = javax.validation.Validation.buildDefaultValidatorFactory();
                javax.validation.Validator validator = validatorFactory.getValidator();
                Set violations = validator.validate(value, new Class[0]);
                Locale localeToUse = this.requestLanguage.getLocaleFromStringOrDefault(this.requestLanguage.getLanguage(context, (Optional<Result>)Optional.absent()));
                Validation validation = context.getValidation();
                for (javax.validation.ConstraintViolation violation : violations) {
                    String violationMessage = validatorFactory.getMessageInterpolator().interpolate(violation.getMessageTemplate(), (MessageInterpolator.Context)new NinjaContextMsgInterpolator(value, violation.getConstraintDescriptor()), localeToUse);
                    ConstraintViolation constraintViolation = ConstraintViolation.create(violationMessage, violation.getInvalidValue());
                    validation.addBeanViolation(new FieldViolation(violation.getPropertyPath().toString(), constraintViolation));
                }
            }
        }

        @Override
        public Class<Object> getValidatedType() {
            return Object.class;
        }
    }

    private static class NinjaContextMsgInterpolator
    implements MessageInterpolator.Context,
    Serializable {
        private final Object value;
        private final ConstraintDescriptor<?> descriptor;

        public NinjaContextMsgInterpolator(Object value, ConstraintDescriptor<?> descriptor) {
            this.value = value;
            this.descriptor = descriptor;
        }

        public ConstraintDescriptor<?> getConstraintDescriptor() {
            return this.descriptor;
        }

        public Object getValidatedValue() {
            return this.value;
        }
    }
}

