/*
 * Decompiled with CFR 0.152.
 */
package ninja.validation;

public class ConstraintViolation {
    private final String messageKey;
    private final String fieldKey;
    private final String defaultMessage;
    private final Object[] messageParams;

    public ConstraintViolation(String messageKey, String fieldKey, String defaultMessage, Object ... messageParams) {
        this.messageKey = messageKey;
        this.fieldKey = fieldKey;
        this.defaultMessage = fieldKey != null ? defaultMessage.replace("{0}", fieldKey) : defaultMessage;
        this.messageParams = messageParams;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public String getFieldKey() {
        return this.fieldKey;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public Object[] getMessageParams() {
        return this.messageParams;
    }

    public static ConstraintViolation create(String messageKey, Object ... messageParams) {
        return new ConstraintViolation(messageKey, null, null, messageParams);
    }

    public static ConstraintViolation createWithDefault(String messageKey, String defaultMessage, Object ... messageParams) {
        return new ConstraintViolation(messageKey, null, defaultMessage, messageParams);
    }

    public static ConstraintViolation createForField(String messageKey, String fieldKey, Object ... messageParams) {
        return new ConstraintViolation(messageKey, fieldKey, null, messageParams);
    }

    public static ConstraintViolation createForFieldWithDefault(String messageKey, String fieldKey, String defaultMessage, Object ... messageParams) {
        return new ConstraintViolation(messageKey, fieldKey, defaultMessage, messageParams);
    }
}

