/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtil {
    private static final Pattern days = Pattern.compile("^([0-9]+)d$");
    private static final Pattern hours = Pattern.compile("^([0-9]+)h$");
    private static final Pattern minutes = Pattern.compile("^([0-9]+)mi?n$");
    private static final Pattern seconds = Pattern.compile("^([0-9]+)s$");

    public static int parseDuration(String duration) {
        if (duration == null) {
            return 2592000;
        }
        int toAdd = -1;
        if (days.matcher(duration).matches()) {
            Matcher matcher = days.matcher(duration);
            matcher.matches();
            toAdd = Integer.parseInt(matcher.group(1)) * 3600 * 24;
        } else if (hours.matcher(duration).matches()) {
            Matcher matcher = hours.matcher(duration);
            matcher.matches();
            toAdd = Integer.parseInt(matcher.group(1)) * 3600;
        } else if (minutes.matcher(duration).matches()) {
            Matcher matcher = minutes.matcher(duration);
            matcher.matches();
            toAdd = Integer.parseInt(matcher.group(1)) * 60;
        } else if (seconds.matcher(duration).matches()) {
            Matcher matcher = seconds.matcher(duration);
            matcher.matches();
            toAdd = Integer.parseInt(matcher.group(1));
        }
        if (toAdd == -1) {
            throw new IllegalArgumentException("Invalid duration pattern : " + duration);
        }
        return toAdd;
    }
}

