/*
 * Decompiled with CFR 0.152.
 */
package ninja.utils;

import com.google.inject.Singleton;
import java.net.URI;
import javax.inject.Inject;
import ninja.utils.NinjaProperties;
import org.apache.commons.lang.StringUtils;

@Singleton
public class OverlayedNinjaProperties {
    private final NinjaProperties ninjaProperties;

    @Inject
    public OverlayedNinjaProperties(NinjaProperties ninjaProperties) {
        this.ninjaProperties = ninjaProperties;
    }

    public String get(String key, String currentValue, String defaultValue) {
        String value = this.ninjaProperties.getWithDefault(key, defaultValue);
        value = System.getProperty(key, value);
        if (StringUtils.isNotEmpty((String)currentValue)) {
            value = currentValue;
        }
        return value;
    }

    public Boolean getBoolean(String key, Boolean currentValue, Boolean defaultValue) {
        String value = this.get(key, this.safeToString(currentValue), this.safeToString(defaultValue));
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        if ("true".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Unable to convert property '" + key + "' with value '" + value + "' to a Boolean");
    }

    public Integer getInteger(String key, Integer currentValue, Integer defaultValue) {
        String value = null;
        try {
            value = this.get(key, this.safeToString(currentValue), this.safeToString(defaultValue));
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to convert property '" + key + "' with value '" + value + "' to an Integer", e);
        }
    }

    public Long getLong(String key, Long currentValue, Long defaultValue) {
        String value = null;
        try {
            value = this.get(key, this.safeToString(currentValue), this.safeToString(defaultValue));
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            return Long.valueOf(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to convert property '" + key + "' with value '" + value + "' to a Long", e);
        }
    }

    public URI getURI(String key, URI currentValue, URI defaultValue) {
        String value = null;
        try {
            value = this.get(key, this.safeToString(currentValue), this.safeToString(defaultValue));
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            return new URI(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to convert property '" + key + "' with value '" + value + "' to a URI", e);
        }
    }

    private String safeToString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

