/*
 * Decompiled with CFR 0.152.
 */
package ninja.template;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ninja.template.TemplateEngine;
import ninja.template.TemplateEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TemplateEngineManagerImpl
implements TemplateEngineManager {
    private final Logger logger = LoggerFactory.getLogger(TemplateEngineManagerImpl.class);
    private final Map<String, Provider<? extends TemplateEngine>> contentTypeToTemplateEngineMap;

    @Inject
    public TemplateEngineManagerImpl(Injector injector) {
        HashMap<String, Provider> map = new HashMap<String, Provider>();
        for (Map.Entry binding : injector.getBindings().entrySet()) {
            if (!TemplateEngine.class.isAssignableFrom(((Key)binding.getKey()).getTypeLiteral().getRawType())) continue;
            Provider provider = ((Binding)binding.getValue()).getProvider();
            map.put(((TemplateEngine)provider.get()).getContentType(), provider);
        }
        this.contentTypeToTemplateEngineMap = ImmutableMap.copyOf(map);
        this.logTemplateEngines();
    }

    @Override
    public Set<String> getContentTypes() {
        return ImmutableSet.copyOf(this.contentTypeToTemplateEngineMap.keySet());
    }

    @Override
    public TemplateEngine getTemplateEngineForContentType(String contentType) {
        Provider<? extends TemplateEngine> provider = this.contentTypeToTemplateEngineMap.get(contentType);
        if (provider != null) {
            return (TemplateEngine)provider.get();
        }
        return null;
    }

    protected final void logTemplateEngines() {
        ArrayList outputTypes = Lists.newArrayList(this.getContentTypes());
        Collections.sort(outputTypes);
        if (outputTypes.isEmpty()) {
            this.logger.error("No registered template engines?! Please install a template module!");
            return;
        }
        int maxContentTypeLen = 0;
        int maxTemplateEngineLen = 0;
        for (String contentType : outputTypes) {
            TemplateEngine templateEngine = this.getTemplateEngineForContentType(contentType);
            maxContentTypeLen = Math.max(maxContentTypeLen, contentType.length());
            maxTemplateEngineLen = Math.max(maxTemplateEngineLen, templateEngine.getClass().getName().length());
        }
        int borderLen = 6 + maxContentTypeLen + maxTemplateEngineLen;
        String border = Strings.padEnd((String)"", (int)borderLen, (char)'-');
        this.logger.info(border);
        this.logger.info("Registered response template engines");
        this.logger.info(border);
        for (String contentType : outputTypes) {
            TemplateEngine templateEngine = this.getTemplateEngineForContentType(contentType);
            this.logger.info("{}  =>  {}", (Object)Strings.padEnd((String)contentType, (int)maxContentTypeLen, (char)' '), (Object)templateEngine.getClass().getName());
        }
    }
}

