/*
 * Decompiled with CFR 0.152.
 */
package ninja.template;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import ninja.Context;
import ninja.Result;
import ninja.template.TemplateEngine;
import ninja.utils.ResponseStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TemplateEngineJson
implements TemplateEngine {
    private final Logger logger = LoggerFactory.getLogger(TemplateEngineJson.class);
    private final ObjectMapper objectMapper;

    @Inject
    public TemplateEngineJson(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public void invoke(Context context, Result result) {
        ResponseStreams responseStreams = context.finalizeHeaders(result);
        try (OutputStream outputStream = responseStreams.getOutputStream();){
            Class<?> jsonView = result.getJsonView();
            if (jsonView != null) {
                this.objectMapper.writerWithView(jsonView).writeValue(outputStream, result.getRenderable());
            } else {
                this.objectMapper.writeValue(outputStream, result.getRenderable());
            }
        }
        catch (IOException e) {
            this.logger.error("Error while rendering json", (Throwable)e);
        }
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public String getSuffixOfTemplatingEngine() {
        return null;
    }
}

