/*
 * Decompiled with CFR 0.152.
 */
package ninja.template;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.List;
import ninja.Router;

@Singleton
public class TemplateEngineFreemarkerReverseRouteHelper {
    final Router router;

    @Inject
    public TemplateEngineFreemarkerReverseRouteHelper(Router router) {
        this.router = router;
    }

    public TemplateModel computeReverseRoute(List args) throws TemplateModelException {
        if (args.size() < 2) {
            throw new TemplateModelException("Please specify at least classname and controller (2 parameters).");
        }
        ArrayList<String> strings = new ArrayList<String>(args.size());
        for (Object o : args) {
            if (o instanceof String) {
                strings.add((String)o);
            }
            if (o instanceof SimpleScalar) {
                strings.add(((SimpleScalar)o).getAsString());
                continue;
            }
            if (!(o instanceof SimpleNumber)) continue;
            strings.add(((SimpleNumber)o).toString());
        }
        try {
            Class<?> clazz = Class.forName((String)strings.get(0));
            Object[] parameterMap = strings.subList(2, strings.size()).toArray();
            String reverseRoute = this.router.getReverseRoute(clazz, (String)strings.get(1), parameterMap);
            return new SimpleScalar(reverseRoute);
        }
        catch (ClassNotFoundException ex) {
            throw new TemplateModelException("Error. Cannot find class for String: " + (String)strings.get(0));
        }
    }
}

