/*
 * Decompiled with CFR 0.152.
 */
package ninja.template;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.List;
import ninja.Context;
import ninja.Result;
import ninja.i18n.Messages;
import ninja.template.TemplateEngineFreemarkerAssetsAtMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateEngineFreemarkerI18nMethod
implements TemplateMethodModelEx {
    public static final Logger logger = LoggerFactory.getLogger(TemplateEngineFreemarkerAssetsAtMethod.class);
    final Messages messages;
    final Context context;
    final Optional<Result> result;

    public TemplateEngineFreemarkerI18nMethod(Messages messages, Context context, Result result) {
        this.messages = messages;
        this.context = context;
        this.result = Optional.of((Object)result);
    }

    public TemplateModel exec(List args) throws TemplateModelException {
        if (args.size() == 1) {
            String messageKey = ((SimpleScalar)args.get(0)).getAsString();
            String messageValue = (String)this.messages.get(messageKey, this.context, this.result, new Object[0]).or((Object)messageKey);
            this.logIfMessageKeyIsMissing(messageKey, messageValue);
            return new SimpleScalar(messageValue);
        }
        if (args.size() > 1) {
            ArrayList strings = Lists.newArrayList();
            for (Object o : args) {
                if (o instanceof SimpleScalar) {
                    strings.add(((SimpleScalar)o).getAsString());
                    continue;
                }
                if (!(o instanceof SimpleNumber)) continue;
                strings.add(((SimpleNumber)o).toString());
            }
            String messageKey = (String)strings.get(0);
            String messageValue = (String)this.messages.get(messageKey, this.context, this.result, strings.subList(1, strings.size()).toArray()).or((Object)messageKey);
            this.logIfMessageKeyIsMissing(messageKey, messageValue);
            return new SimpleScalar(messageValue);
        }
        throw new TemplateModelException("Using i18n without any key is not possible.");
    }

    public void logIfMessageKeyIsMissing(String messageKey, String messageValue) {
        if (messageKey.equals(messageValue)) {
            logger.error("Message key {} missing. Using key as value inside template - but this is most likely not what you want.", (Object)messageKey);
        }
    }
}

