/*
 * Decompiled with CFR 0.152.
 */
package ninja.template;

import com.google.common.base.CaseFormat;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import freemarker.template.Version;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Singleton;
import ninja.Context;
import ninja.Result;
import ninja.exceptions.RenderingException;
import ninja.i18n.Lang;
import ninja.i18n.Messages;
import ninja.template.TemplateEngine;
import ninja.template.TemplateEngineFreemarkerAssetsAtMethod;
import ninja.template.TemplateEngineFreemarkerEscapedLoader;
import ninja.template.TemplateEngineFreemarkerI18nMethod;
import ninja.template.TemplateEngineFreemarkerPrettyTimeMethod;
import ninja.template.TemplateEngineFreemarkerReverseRouteMethod;
import ninja.template.TemplateEngineFreemarkerWebJarsAtMethod;
import ninja.template.TemplateEngineHelper;
import ninja.template.TemplateEngineManager;
import ninja.template.directives.TemplateEngineFreemarkerAuthenticityFormDirective;
import ninja.template.directives.TemplateEngineFreemarkerAuthenticityTokenDirective;
import ninja.utils.NinjaProperties;
import ninja.utils.ResponseStreams;
import org.slf4j.Logger;

@Singleton
public class TemplateEngineFreemarker
implements TemplateEngine {
    public static final String FREEMARKER_CONFIGURATION_FILE_SUFFIX = "freemarker.suffix";
    private final Version INCOMPATIBLE_IMPROVEMENTS_VERSION = new Version(2, 3, 22);
    private final String FILE_SUFFIX = ".ftl.html";
    private final Configuration cfg;
    private final NinjaProperties ninjaProperties;
    private final Messages messages;
    private final Lang lang;
    private final TemplateEngineHelper templateEngineHelper;
    private final Logger logger;
    private final TemplateEngineFreemarkerReverseRouteMethod templateEngineFreemarkerReverseRouteMethod;
    private final TemplateEngineFreemarkerAssetsAtMethod templateEngineFreemarkerAssetsAtMethod;
    private final TemplateEngineFreemarkerWebJarsAtMethod templateEngineFreemarkerWebJarsAtMethod;
    private final String fileSuffix;

    @Inject
    public TemplateEngineFreemarker(Messages messages, Lang lang, Logger logger, TemplateEngineHelper templateEngineHelper, TemplateEngineManager templateEngineManager, TemplateEngineFreemarkerReverseRouteMethod templateEngineFreemarkerReverseRouteMethod, TemplateEngineFreemarkerAssetsAtMethod templateEngineFreemarkerAssetsAtMethod, TemplateEngineFreemarkerWebJarsAtMethod templateEngineFreemarkerWebJarsAtMethod, NinjaProperties ninjaProperties) throws Exception {
        this.messages = messages;
        this.lang = lang;
        this.logger = logger;
        this.ninjaProperties = ninjaProperties;
        this.templateEngineHelper = templateEngineHelper;
        this.templateEngineFreemarkerReverseRouteMethod = templateEngineFreemarkerReverseRouteMethod;
        this.templateEngineFreemarkerAssetsAtMethod = templateEngineFreemarkerAssetsAtMethod;
        this.templateEngineFreemarkerWebJarsAtMethod = templateEngineFreemarkerWebJarsAtMethod;
        this.fileSuffix = ninjaProperties.getWithDefault(FREEMARKER_CONFIGURATION_FILE_SUFFIX, ".ftl.html");
        this.cfg = new Configuration(this.INCOMPATIBLE_IMPROVEMENTS_VERSION);
        this.cfg.setDefaultEncoding("utf-8");
        this.cfg.setOutputEncoding("utf-8");
        this.cfg.setLocalizedLookup(false);
        String srcDir = System.getProperty("user.dir") + File.separator + "src" + File.separator + "main" + File.separator + "java";
        if (ninjaProperties.isDev() && new File(srcDir).exists()) {
            try {
                FileTemplateLoader fileTemplateLoader = new FileTemplateLoader(new File(srcDir));
                ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(this.getClass(), "/");
                TemplateLoader[] templateLoader = new TemplateLoader[]{fileTemplateLoader, classTemplateLoader};
                MultiTemplateLoader multiTemplateLoader = new MultiTemplateLoader(templateLoader);
                this.cfg.setTemplateLoader((TemplateLoader)multiTemplateLoader);
            }
            catch (IOException e) {
                logger.error("Error Loading Freemarker Template " + srcDir, (Throwable)e);
            }
            this.cfg.setTemplateUpdateDelay(1);
        } else {
            this.cfg.setClassForTemplateLoading(this.getClass(), "/");
            this.cfg.setTemplateUpdateDelay(Integer.MAX_VALUE);
            this.cfg.setCacheStorage((CacheStorage)new MruCacheStorage(20, Integer.MAX_VALUE));
        }
        this.cfg.setTemplateLoader((TemplateLoader)new TemplateEngineFreemarkerEscapedLoader(this.cfg.getTemplateLoader()));
        this.cfg.setNumberFormat("0.######");
        this.cfg.setObjectWrapper((ObjectWrapper)this.createBeansWrapperWithExposedFields());
    }

    @Override
    public void invoke(Context context, Result result) {
        Map<String, Map<String, String>> map;
        Object object = result.getRenderable();
        if (object == null) {
            map = Maps.newHashMap();
        } else if (object instanceof Map) {
            map = (Map)object;
        } else {
            String realClassNameLowerCamelCase = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, object.getClass().getSimpleName());
            map = Maps.newHashMap();
            map.put(realClassNameLowerCamelCase, (Map<String, String>)object);
        }
        Optional<String> language = this.lang.getLanguage(context, (Optional<Result>)Optional.of((Object)result));
        if (language.isPresent()) {
            map.put("lang", (Map<String, String>)language.get());
        }
        if (!context.getSession().isEmpty()) {
            map.put("session", context.getSession().getData());
        }
        map.put("contextPath", (Map<String, String>)((Object)context.getContextPath()));
        map.put("i18n", (Map<String, String>)((Object)new TemplateEngineFreemarkerI18nMethod(this.messages, context, result)));
        Optional<String> requestLang = this.lang.getLanguage(context, (Optional<Result>)Optional.of((Object)result));
        Locale locale = this.lang.getLocaleFromStringOrDefault(requestLang);
        map.put("prettyTime", (Map<String, String>)((Object)new TemplateEngineFreemarkerPrettyTimeMethod(locale)));
        map.put("reverseRoute", (Map<String, String>)((Object)this.templateEngineFreemarkerReverseRouteMethod));
        map.put("assetsAt", (Map<String, String>)((Object)this.templateEngineFreemarkerAssetsAtMethod));
        map.put("webJarsAt", (Map<String, String>)((Object)this.templateEngineFreemarkerWebJarsAtMethod));
        map.put("authenticityToken", (Map<String, String>)((Object)new TemplateEngineFreemarkerAuthenticityTokenDirective(context)));
        map.put("authenticityForm", (Map<String, String>)((Object)new TemplateEngineFreemarkerAuthenticityFormDirective(context)));
        HashMap translatedFlashCookieMap = Maps.newHashMap();
        for (Map.Entry<String, String> entry : context.getFlashScope().getCurrentFlashCookieData().entrySet()) {
            String messageValue = null;
            Optional<String> messageValueOptional = this.messages.get(entry.getValue(), context, (Optional<Result>)Optional.of((Object)result), new Object[0]);
            messageValue = !messageValueOptional.isPresent() ? entry.getValue() : (String)messageValueOptional.get();
            translatedFlashCookieMap.put(entry.getKey(), messageValue);
        }
        map.put("flash", translatedFlashCookieMap);
        String templateName = this.templateEngineHelper.getTemplateForResult(context.getRoute(), result, this.fileSuffix);
        Template freemarkerTemplate = null;
        try {
            freemarkerTemplate = this.cfg.getTemplate(templateName);
            StringWriter buffer = new StringWriter(65536);
            freemarkerTemplate.process(map, (Writer)buffer);
            ResponseStreams responseStreams = context.finalizeHeaders(result);
            try (Writer writer = responseStreams.getWriter();){
                writer.write(buffer.toString());
            }
        }
        catch (Exception cause) {
            this.throwRenderingException(context, result, cause, templateName);
        }
    }

    public void throwRenderingException(Context context, Result result, Exception cause, String knownTemplateSourcePath) {
        if (cause instanceof IOException && cause.getCause() != null && cause.getCause() instanceof ParseException) {
            cause = (ParseException)cause.getCause();
        }
        if (cause instanceof TemplateNotFoundException) {
            throw new RenderingException(cause.getMessage(), cause, result, "FreeMarker template not found", knownTemplateSourcePath, -1);
        }
        if (cause instanceof TemplateException) {
            TemplateException te = (TemplateException)cause;
            String templateSourcePath = te.getTemplateSourceName();
            if (templateSourcePath == null) {
                templateSourcePath = knownTemplateSourcePath;
            }
            throw new RenderingException(cause.getMessage(), cause, result, "FreeMarker render exception", templateSourcePath, te.getLineNumber());
        }
        if (cause instanceof ParseException) {
            ParseException pe = (ParseException)cause;
            String templateSourcePath = pe.getTemplateName();
            if (templateSourcePath == null) {
                templateSourcePath = knownTemplateSourcePath;
            }
            throw new RenderingException(cause.getMessage(), cause, result, "FreeMarker parser exception", templateSourcePath, pe.getLineNumber());
        }
        throw new RenderingException(cause.getMessage(), cause, result, knownTemplateSourcePath, -1);
    }

    @Override
    public String getContentType() {
        return "text/html";
    }

    @Override
    public String getSuffixOfTemplatingEngine() {
        return this.fileSuffix;
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    private BeansWrapper createBeansWrapperWithExposedFields() {
        DefaultObjectWrapperBuilder defaultObjectWrapperBuilder = new DefaultObjectWrapperBuilder(this.INCOMPATIBLE_IMPROVEMENTS_VERSION);
        defaultObjectWrapperBuilder.setExposeFields(true);
        DefaultObjectWrapper defaultObjectWrapper = defaultObjectWrapperBuilder.build();
        return defaultObjectWrapper;
    }

    static {
        try {
            freemarker.log.Logger.selectLoggerLibrary((int)5);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

