/*
 * Decompiled with CFR 0.152.
 */
package ninja.standalone;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URL;
import java.security.KeyStore;
import java.util.Iterator;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import ninja.standalone.Standalone;
import ninja.utils.ForwardingServiceLoader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneHelper {
    private static final Logger log = LoggerFactory.getLogger(StandaloneHelper.class);
    private static final String URI_SCHEME_CLASSPATH = "classpath";

    public static int findAvailablePort(int min, int max) {
        for (int port = min; port < max; ++port) {
            try {
                new ServerSocket(port).close();
                return port;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        throw new IllegalStateException("Could not find available port in range " + min + " to " + max);
    }

    public static Class<? extends Standalone> resolveStandaloneClass() {
        return StandaloneHelper.resolveStandaloneClass(System.getProperty("ninja.standalone.class"), ForwardingServiceLoader.loadWithSystemServiceLoader(Standalone.class), "ninja.standalone.NinjaJetty");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class<? extends Standalone> resolveStandaloneClass(String standaloneClassNameSystemProperty, ForwardingServiceLoader<Standalone> standaloneServiceLoader, String standaloneClassNameDefaultValue) {
        Class<?> resolvedStandaloneClass = null;
        if (standaloneClassNameSystemProperty != null) {
            try {
                resolvedStandaloneClass = Class.forName(standaloneClassNameSystemProperty);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to find standalone class '" + standaloneClassNameSystemProperty + "' (class does not exist)");
            }
        }
        if (resolvedStandaloneClass == null) {
            try {
                Iterator<Standalone> standaloneIterator = standaloneServiceLoader.iterator();
                if (standaloneIterator.hasNext()) {
                    resolvedStandaloneClass = standaloneIterator.next().getClass();
                }
                if (standaloneIterator.hasNext()) {
                    log.warn("More than one implementation of {} on classpath! Using {} which was the first", Standalone.class, resolvedStandaloneClass);
                }
            }
            finally {
                standaloneServiceLoader.reload();
            }
        }
        if (resolvedStandaloneClass == null) {
            try {
                resolvedStandaloneClass = Class.forName(standaloneClassNameDefaultValue);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to find standalone class '" + standaloneClassNameDefaultValue + "' (class does not exist)");
            }
        }
        return resolvedStandaloneClass;
    }

    public static Standalone create(Class<? extends Standalone> standaloneClass) {
        try {
            return standaloneClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to create " + standaloneClass.getCanonicalName() + " (either not on classpath or invalid class name)");
        }
    }

    static void checkContextPath(String contextPath) {
        if (StringUtils.isEmpty((CharSequence)contextPath)) {
            return;
        }
        if (!contextPath.startsWith("/")) {
            throw new IllegalArgumentException("A context path must start with a '/' character.  See https://docs.oracle.com/javaee/6/api/javax/servlet/ServletContext.html#getContextPath() for more info");
        }
        if (contextPath.endsWith("/")) {
            throw new IllegalArgumentException("A context path must not end with a '/' character.  See https://docs.oracle.com/javaee/6/api/javax/servlet/ServletContext.html#getContextPath() for more info");
        }
    }

    public static InputStream openKeyStoreInput(URI uri) throws IOException {
        if (uri.getScheme().equals(URI_SCHEME_CLASSPATH)) {
            String resourceName = uri.getPath();
            log.debug("Opening keystore on classpath with resource {}", (Object)resourceName);
            InputStream stream = StandaloneHelper.class.getResourceAsStream(resourceName);
            if (stream == null) {
                throw new IOException("Resource '" + resourceName + "' not found on classpath");
            }
            return stream;
        }
        URL url = uri.toURL();
        log.debug("Opening keystore with url {}", (Object)url);
        return url.openStream();
    }

    public static KeyStore loadKeyStore(URI uri, char[] password) throws Exception {
        try (InputStream stream = StandaloneHelper.openKeyStoreInput(uri);){
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(stream, password);
            KeyStore keyStore = ks;
            return keyStore;
        }
    }

    public static SSLContext createSSLContext(URI keystoreUri, char[] keystorePassword, URI truststoreUri, char[] truststorePassword) throws Exception {
        KeyStore keystore = StandaloneHelper.loadKeyStore(keystoreUri, keystorePassword);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keystore, keystorePassword);
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        KeyStore truststore = StandaloneHelper.loadKeyStore(truststoreUri, truststorePassword);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(truststore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }
}

