/*
 * Decompiled with CFR 0.152.
 */
package ninja.standalone;

import com.google.inject.Injector;
import java.net.URI;
import java.util.List;
import ninja.utils.NinjaMode;
import ninja.utils.NinjaPropertiesImpl;

public interface Standalone<T extends Standalone> {
    public static final String KEY_NINJA_STANDALONE_CLASS = "ninja.standalone.class";
    public static final String KEY_NINJA_CONTEXT_PATH = "ninja.context";
    public static final String KEY_NINJA_HOST = "ninja.host";
    public static final String KEY_NINJA_IDLE_TIMEOUT = "ninja.idle.timeout";
    public static final String KEY_NINJA_PORT = "ninja.port";
    public static final String KEY_NINJA_SSL_PORT = "ninja.ssl.port";
    public static final String KEY_NINJA_SSL_KEYSTORE_URI = "ninja.ssl.keystore.uri";
    public static final String KEY_NINJA_SSL_KEYSTORE_PASSWORD = "ninja.ssl.keystore.password";
    public static final String KEY_NINJA_SSL_TRUSTSTORE_URI = "ninja.ssl.truststore.uri";
    public static final String KEY_NINJA_SSL_TRUSTSTORE_PASSWORD = "ninja.ssl.truststore.password";
    public static final String DEFAULT_STANDALONE_CLASS = "ninja.standalone.NinjaJetty";
    public static final String DEFAULT_HOST = null;
    public static final Integer DEFAULT_PORT = 8080;
    public static final Long DEFAULT_IDLE_TIMEOUT = 30000L;
    public static final String DEFAULT_CONTEXT_PATH = "";
    public static final Integer DEFAULT_SSL_PORT = -1;
    public static final String DEFAULT_DEV_NINJA_SSL_KEYSTORE_URI = "classpath:/ninja/standalone/ninja-development.keystore";
    public static final String DEFAULT_DEV_NINJA_SSL_KEYSTORE_PASSWORD = "password";
    public static final String DEFAULT_DEV_NINJA_SSL_TRUSTSTORE_URI = "classpath:/ninja/standalone/ninja-development.truststore";
    public static final String DEFAULT_DEV_NINJA_SSL_TRUSTSTORE_PASSWORD = "password";

    public T configure() throws Exception;

    public void run();

    public T start() throws Exception;

    public T join() throws Exception;

    public T shutdown();

    public NinjaMode getNinjaMode();

    public T ninjaMode(NinjaMode var1);

    public String getExternalConfigurationPath();

    public T externalConfigurationPath(String var1);

    public String getName();

    public T name(String var1);

    public String getHost();

    public T host(String var1);

    public Integer getPort();

    public T port(int var1);

    public String getContextPath();

    public T contextPath(String var1);

    public T idleTimeout(long var1);

    public Long getIdleTimeout();

    public Integer getSslPort();

    public T sslPort(int var1);

    public URI getSslKeystoreUri();

    public T sslKeystoreUri(URI var1);

    public String getSslKeystorePassword();

    public T sslKeystorePassword(String var1);

    public URI getSslTruststoreUri();

    public T sslTruststoreUri(URI var1);

    public String getSslTruststorePassword();

    public T sslTruststorePassword(String var1);

    public NinjaPropertiesImpl getNinjaProperties();

    public Injector getInjector();

    public List<String> getServerUrls();

    public List<String> getBaseUrls();

    public boolean isPortEnabled();

    public boolean isSslPortEnabled();
}

