/*
 * Decompiled with CFR 0.152.
 */
package ninja.scheduler;

import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import ninja.lifecycle.Dispose;
import ninja.lifecycle.Start;
import ninja.scheduler.Schedule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Scheduler {
    private static final Logger log = LoggerFactory.getLogger(Scheduler.class);
    @Inject
    private Injector injector;
    private volatile ScheduledExecutorService executor;
    private final List<Object> objectsToSchedule = Collections.synchronizedList(new ArrayList());

    @Start(order=90)
    public void start() {
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.scheduleCachedObjects();
    }

    @Dispose(order=90)
    public void dispose() {
        this.executor.shutdown();
        this.executor = null;
    }

    public boolean hasScheduledMethod(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            Schedule schedule = method.getAnnotation(Schedule.class);
            if (schedule == null) continue;
            return true;
        }
        return false;
    }

    public void schedule(Object target) {
        if (this.executor == null) {
            this.objectsToSchedule.add(target);
        } else {
            for (Method method : target.getClass().getMethods()) {
                Schedule schedule = method.getAnnotation(Schedule.class);
                if (schedule == null) continue;
                this.schedule(target, method, schedule);
            }
        }
    }

    private void scheduleCachedObjects() {
        ArrayList<Object> copy = new ArrayList<Object>(this.objectsToSchedule);
        this.objectsToSchedule.clear();
        for (Object e : copy) {
            this.schedule(e);
        }
    }

    private void schedule(final Object target, final Method method, Schedule schedule) {
        String initialDelayString;
        String timeUnitString;
        long delay = schedule.delay();
        if (!schedule.delayProperty().equals("_no-property")) {
            String delayString = this.getProperty(schedule.delayProperty());
            if (delayString != null) {
                delay = Long.parseLong(delayString);
            } else if (delay < 0L) {
                throw new IllegalArgumentException("No delay property found: " + schedule.delayProperty() + " and no default delay set");
            }
        }
        if (delay < 0L) {
            throw new IllegalArgumentException("No delay or delay property specified");
        }
        TimeUnit timeUnit = schedule.timeUnit();
        if (!schedule.timeUnitProperty().equals("_no-property") && (timeUnitString = this.getProperty(schedule.timeUnitProperty())) != null) {
            timeUnit = TimeUnit.valueOf(timeUnitString);
        }
        long initialDelay = schedule.initialDelay();
        if (!schedule.initialDelayProperty().equals("_no-property") && (initialDelayString = this.getProperty(schedule.initialDelayProperty())) != null) {
            initialDelay = Long.parseLong(initialDelayString);
        }
        if (initialDelay < 0L) {
            initialDelay = delay;
        }
        log.info("Scheduling method " + method.getName() + " on " + target + " to be run every " + delay + " " + (Object)((Object)timeUnit) + " after " + initialDelay + " " + (Object)((Object)timeUnit));
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    log.debug("Running scheduled method {} on {}", (Object)method.getName(), target);
                    method.invoke(target, new Object[0]);
                }
                catch (Exception e) {
                    log.error("Error invoking scheduled run of method " + method.getName() + " on " + target, (Throwable)e);
                }
            }
        }, initialDelay, delay, timeUnit);
    }

    private String getProperty(String name) {
        try {
            return (String)this.injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)name)));
        }
        catch (ConfigurationException e) {
            return null;
        }
    }
}

