/*
 * Decompiled with CFR 0.152.
 */
package ninja.postoffice.commonsmail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import ninja.postoffice.Mail;
import ninja.postoffice.common.Tuple;
import ninja.postoffice.commonsmail.CommonsmailHelper;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;

public class CommonsmailHelperImpl
implements CommonsmailHelper {
    @Override
    public MultiPartEmail createMultiPartEmailWithContent(Mail mail) throws EmailException {
        MultiPartEmail multiPartEmail;
        if (mail.getBodyHtml() == null || mail.getBodyHtml().equals("")) {
            multiPartEmail = new MultiPartEmail();
            multiPartEmail.setMsg(mail.getBodyText());
        } else {
            multiPartEmail = mail.getBodyText() == null || mail.getBodyText().equals("") ? new HtmlEmail().setHtmlMsg(mail.getBodyHtml()) : new HtmlEmail().setHtmlMsg(mail.getBodyHtml()).setTextMsg(mail.getBodyText());
        }
        return multiPartEmail;
    }

    @Override
    public void doPopulateMultipartMailWithContent(MultiPartEmail multiPartEmail, Mail mail) throws AddressException, EmailException {
        List<Tuple<String, String>> emails;
        String charset = "utf-8";
        if (mail.getCharset() != null) {
            charset = mail.getCharset();
        }
        multiPartEmail.setCharset(charset);
        String subject = "";
        if (mail.getSubject() != null) {
            subject = mail.getSubject();
        }
        multiPartEmail.setSubject(subject);
        if (mail.getFrom() != null) {
            Tuple<String, String> from = this.createValidEmailFromString(mail.getFrom());
            if (from.y != null) {
                multiPartEmail.setFrom((String)from.x, (String)from.y);
            } else {
                multiPartEmail.setFrom((String)from.x);
            }
        }
        if (mail.getTos() != null && !mail.getTos().isEmpty()) {
            emails = this.createListOfAddresses(mail.getTos());
            for (Tuple<String, String> email : emails) {
                if (email.y != null) {
                    multiPartEmail.addTo((String)email.x, (String)email.y);
                    continue;
                }
                multiPartEmail.addTo((String)email.x);
            }
        }
        if (mail.getReplyTo() != null && !mail.getReplyTo().isEmpty()) {
            emails = this.createListOfAddresses(mail.getReplyTo());
            for (Tuple<String, String> email : emails) {
                multiPartEmail.addReplyTo((String)email.x, (String)email.y);
            }
        }
        if (mail.getCcs() != null && !mail.getCcs().isEmpty()) {
            emails = this.createListOfAddresses(mail.getCcs());
            for (Tuple<String, String> email : emails) {
                multiPartEmail.addCc((String)email.x, (String)email.y);
            }
        }
        if (mail.getBccs() != null && !mail.getBccs().isEmpty()) {
            emails = this.createListOfAddresses(mail.getBccs());
            for (Tuple<String, String> email : emails) {
                multiPartEmail.addBcc((String)email.x, (String)email.y);
            }
        }
        if (mail.getHeaders() != null) {
            multiPartEmail.setHeaders(mail.getHeaders());
        }
    }

    @Override
    public void doSetServerParameter(MultiPartEmail multiPartEmail, String smtpHost, Integer smtpPort, Boolean smtpSsl, String smtpUser, String smtpPassword, Boolean smtpDebug) {
        multiPartEmail.setHostName(smtpHost);
        multiPartEmail.setSmtpPort(smtpPort.intValue());
        multiPartEmail.setSSLOnConnect(smtpSsl.booleanValue());
        if (smtpUser != null) {
            multiPartEmail.setAuthentication(smtpUser, smtpPassword);
        }
        multiPartEmail.setDebug(smtpDebug.booleanValue());
    }

    @Override
    public List<Tuple<String, String>> createListOfAddresses(Collection<String> emails) throws AddressException {
        ArrayList<Tuple<String, String>> tuples = new ArrayList<Tuple<String, String>>();
        for (String email : emails) {
            tuples.add(this.createValidEmailFromString(email));
        }
        return tuples;
    }

    @Override
    public Tuple<String, String> createValidEmailFromString(String email) throws AddressException {
        InternetAddress internetAddress = new InternetAddress(email);
        Tuple<String, String> tuple = new Tuple<String, String>(internetAddress.getAddress(), internetAddress.getPersonal());
        return tuple;
    }
}

