/*
 * Decompiled with CFR 0.152.
 */
package ninja.postoffice;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import ninja.postoffice.Postoffice;
import ninja.postoffice.mock.PostofficeMockImpl;
import ninja.utils.ImplFromPropertiesFactory;
import ninja.utils.NinjaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PostofficeProvider
implements Provider<Postoffice> {
    private static final Logger logger = LoggerFactory.getLogger(PostofficeProvider.class);
    private final ImplFromPropertiesFactory<Postoffice> factory;
    private final Supplier<Postoffice> supplier;

    @Inject
    public PostofficeProvider(Injector injector, NinjaProperties ninjaProperties) {
        this.factory = new ImplFromPropertiesFactory<Postoffice>(injector, ninjaProperties, "postoffice.implementation", Postoffice.class, ninjaProperties.isProd() ? "ninja.postoffice.commonsmail.PostofficeCommonsmailImpl" : PostofficeMockImpl.class.getCanonicalName(), true, logger);
        this.supplier = Suppliers.memoize((Supplier)new Supplier<Postoffice>(){

            public Postoffice get() {
                return (Postoffice)PostofficeProvider.this.factory.create();
            }
        });
    }

    public Postoffice get() {
        return (Postoffice)this.supplier.get();
    }
}

