/*
 * Decompiled with CFR 0.152.
 */
package ninja.params;

import java.util.List;
import ninja.Context;
import ninja.params.ArgumentExtractor;
import ninja.validation.Validator;

public class ValidatingArgumentExtractor<T>
implements ArgumentExtractor<T> {
    private final ArgumentExtractor<T> wrapped;
    private final List<Validator<T>> validators;

    public ValidatingArgumentExtractor(ArgumentExtractor<T> wrapped, List<Validator<T>> validators) {
        this.wrapped = wrapped;
        this.validators = validators;
    }

    @Override
    public T extract(Context context) {
        T value = this.wrapped.extract(context);
        if (context.getValidation().hasFieldViolation(this.wrapped.getFieldName())) {
            return value;
        }
        for (Validator<T> validator : this.validators) {
            validator.validate(value, this.wrapped.getFieldName(), context);
            if (!context.getValidation().hasFieldViolation(this.wrapped.getFieldName())) continue;
            break;
        }
        return value;
    }

    @Override
    public Class<T> getExtractedType() {
        return this.wrapped.getExtractedType();
    }

    @Override
    public String getFieldName() {
        return this.wrapped.getFieldName();
    }
}

