/*
 * Decompiled with CFR 0.152.
 */
package ninja.params;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import ninja.Context;
import ninja.RoutingException;
import ninja.params.ArgumentClassHolder;
import ninja.params.ArgumentExtractor;
import ninja.params.ArgumentExtractors;
import ninja.params.ParamParser;
import ninja.params.ParamParsers;
import ninja.params.ParsingArgumentExtractor;
import ninja.params.ParsingArrayExtractor;
import ninja.params.ValidatingArgumentExtractor;
import ninja.params.WithArgumentExtractor;
import ninja.params.WithArgumentExtractors;
import ninja.validation.Validator;
import ninja.validation.WithValidator;

public class ControllerMethodInvoker {
    private final Method method;
    private final ArgumentExtractor<?>[] argumentExtractors;

    ControllerMethodInvoker(Method method, ArgumentExtractor<?>[] argumentExtractors) {
        this.method = method;
        this.argumentExtractors = argumentExtractors;
    }

    public Object invoke(Object controller, Context context) {
        Object[] arguments = new Object[this.argumentExtractors.length];
        for (int i = 0; i < this.argumentExtractors.length; ++i) {
            arguments[i] = this.argumentExtractors[i].extract(context);
        }
        try {
            return this.method.invoke(controller, arguments);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public static ControllerMethodInvoker build(Method method, Injector injector) {
        int i;
        Class<?>[] paramTypes = method.getParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        ArgumentExtractor[] argumentExtractors = new ArgumentExtractor[paramTypes.length];
        for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            try {
                argumentExtractors[i2] = ControllerMethodInvoker.getArgumentExtractor(paramTypes[i2], paramAnnotations[i2], injector);
                continue;
            }
            catch (RoutingException e) {
                throw new RoutingException("Error building argument extractor for parameter " + i2 + " in method " + method.getDeclaringClass().getName() + "." + method.getName() + "()", e);
            }
        }
        int bodyAsFound = -1;
        for (i = 0; i < argumentExtractors.length; ++i) {
            if (argumentExtractors[i] != null) continue;
            if (bodyAsFound > -1) {
                throw new RoutingException("Only one parameter may be deserialised as the body " + method.getDeclaringClass().getName() + "." + method.getName() + "()\nExtracted parameter is type: " + paramTypes[bodyAsFound].getName() + "\nExtra parmeter is type: " + paramTypes[i].getName());
            }
            argumentExtractors[i] = new ArgumentExtractors.BodyAsExtractor(paramTypes[i]);
            bodyAsFound = i;
        }
        for (i = 0; i < argumentExtractors.length; ++i) {
            argumentExtractors[i] = ControllerMethodInvoker.validateArgumentWithExtractor(paramTypes[i], paramAnnotations[i], injector, argumentExtractors[i]);
        }
        return new ControllerMethodInvoker(method, argumentExtractors);
    }

    private static ArgumentExtractor<?> getArgumentExtractor(Class<?> paramType, Annotation[] annotations, Injector injector) {
        ArgumentExtractor<?> extractor = ArgumentExtractors.getExtractorForType(paramType);
        if (extractor == null) {
            block0: for (Annotation annotation : annotations) {
                WithArgumentExtractors withArgumentExtractors = annotation.annotationType().getAnnotation(WithArgumentExtractors.class);
                if (withArgumentExtractors == null) continue;
                for (Class<ArgumentExtractor<?>> clazz : withArgumentExtractors.value()) {
                    Class extractedType = (Class)((ParameterizedType)clazz.getGenericInterfaces()[0]).getActualTypeArguments()[0];
                    if (!paramType.isAssignableFrom(extractedType)) continue;
                    extractor = ControllerMethodInvoker.instantiateComponent(clazz, annotation, paramType, injector);
                    continue block0;
                }
            }
        }
        if (extractor == null) {
            for (Annotation annotation : annotations) {
                WithArgumentExtractor withArgumentExtractor = annotation.annotationType().getAnnotation(WithArgumentExtractor.class);
                if (withArgumentExtractor == null) continue;
                extractor = ControllerMethodInvoker.instantiateComponent(withArgumentExtractor.value(), annotation, paramType, injector);
                break;
            }
        }
        return extractor;
    }

    private static ArgumentExtractor<?> validateArgumentWithExtractor(Class<?> paramType, Annotation[] annotations, Injector injector, ArgumentExtractor<?> extractor) {
        ArrayList preParseValidators = new ArrayList();
        ArrayList postParseValidators = new ArrayList();
        Class<?> boxedParamType = paramType;
        if (paramType.isPrimitive()) {
            boxedParamType = ControllerMethodInvoker.box(paramType);
        }
        for (Annotation annotation : annotations) {
            WithValidator withValidator = annotation.annotationType().getAnnotation(WithValidator.class);
            if (withValidator == null) continue;
            Validator<?> validator = ControllerMethodInvoker.instantiateComponent(withValidator.value(), annotation, paramType, injector);
            if (validator.getValidatedType().isAssignableFrom(extractor.getExtractedType())) {
                preParseValidators.add(validator);
                continue;
            }
            if (validator.getValidatedType().isAssignableFrom(boxedParamType)) {
                postParseValidators.add(validator);
                continue;
            }
            throw new RoutingException("Validator for field " + extractor.getFieldName() + " validates type " + validator.getValidatedType() + ", which doesn't match extracted type " + extractor.getExtractedType() + " or parameter type " + paramType);
        }
        if (!preParseValidators.isEmpty()) {
            extractor = new ValidatingArgumentExtractor(extractor, preParseValidators);
        }
        if (!boxedParamType.isAssignableFrom(extractor.getExtractedType()) && extractor.getFieldName() != null) {
            Object parser;
            if (String.class.isAssignableFrom(extractor.getExtractedType())) {
                parser = ((ParamParsers)injector.getInstance(ParamParsers.class)).getParamParser(paramType);
                if (parser == null) {
                    throw new RoutingException("Can't find parameter parser for type " + extractor.getExtractedType() + " on field " + extractor.getFieldName());
                }
                extractor = new ParsingArgumentExtractor((ArgumentExtractor<String>)extractor, (ParamParser<?>)parser);
            } else if (String[].class.isAssignableFrom(extractor.getExtractedType())) {
                parser = ((ParamParsers)injector.getInstance(ParamParsers.class)).getArrayParser(paramType);
                if (parser == null) {
                    throw new RoutingException("Can't find parameter array parser for type " + extractor.getExtractedType() + " on field " + extractor.getFieldName());
                }
                extractor = new ParsingArrayExtractor((ArgumentExtractor<String[]>)extractor, (ParamParsers.ArrayParamParser<?>)parser);
            } else {
                throw new RoutingException("Extracted type " + extractor.getExtractedType() + " for field " + extractor.getFieldName() + " doesn't match parameter type " + paramType);
            }
        }
        if (!postParseValidators.isEmpty()) {
            extractor = new ValidatingArgumentExtractor(extractor, postParseValidators);
        }
        return extractor;
    }

    private static <T> T instantiateComponent(Class<? extends T> argumentExtractor, final Annotation annotation, final Class<?> paramType, Injector injector) {
        Constructor noarg = ControllerMethodInvoker.getNoArgConstructor(argumentExtractor);
        if (noarg != null) {
            try {
                return noarg.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RoutingException(e);
            }
        }
        Constructor simple = ControllerMethodInvoker.getSingleArgConstructor(argumentExtractor, annotation.annotationType());
        if (simple != null) {
            try {
                return simple.newInstance(annotation);
            }
            catch (Exception e) {
                throw new RoutingException(e);
            }
        }
        Constructor simpleClass = ControllerMethodInvoker.getSingleArgConstructor(argumentExtractor, Class.class);
        if (simpleClass != null) {
            try {
                return simpleClass.newInstance(paramType);
            }
            catch (Exception e) {
                throw new RoutingException(e);
            }
        }
        return (T)injector.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(annotation.annotationType()).toInstance((Object)annotation);
                this.bind(ArgumentClassHolder.class).toInstance((Object)new ArgumentClassHolder(paramType));
            }
        }}).getInstance(argumentExtractor);
    }

    private static Constructor getNoArgConstructor(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            return constructor;
        }
        return null;
    }

    private static Constructor getSingleArgConstructor(Class<?> clazz, Class<?> arg) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].isAssignableFrom(arg)) continue;
            return constructor;
        }
        return null;
    }

    private static Class<?> box(Class<?> typeToBox) {
        if (typeToBox == Integer.TYPE) {
            return Integer.class;
        }
        if (typeToBox == Boolean.TYPE) {
            return Boolean.class;
        }
        if (typeToBox == Long.TYPE) {
            return Long.class;
        }
        if (typeToBox == Float.TYPE) {
            return Float.class;
        }
        if (typeToBox == Double.TYPE) {
            return Double.class;
        }
        if (typeToBox == Byte.TYPE) {
            return Byte.class;
        }
        if (typeToBox == Short.TYPE) {
            return Short.class;
        }
        if (typeToBox == Character.TYPE) {
            return Character.class;
        }
        throw new IllegalArgumentException("Don't know how to box type of " + typeToBox);
    }
}

