/*
 * Decompiled with CFR 0.152.
 */
package ninja.i18n;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.Locale;
import ninja.Context;
import ninja.Cookie;
import ninja.Result;
import ninja.i18n.Lang;
import ninja.utils.NinjaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LangImpl
implements Lang {
    private static Logger logger = LoggerFactory.getLogger(LangImpl.class);
    private final String applicationCookiePrefix;
    private final int TEN_YEARS = 315360000;
    private final NinjaProperties ninjaProperties;
    private final String DEFAULT_LANGUAGE;

    @Inject
    public LangImpl(NinjaProperties ninjaProperties) {
        this.ninjaProperties = ninjaProperties;
        this.applicationCookiePrefix = ninjaProperties.getOrDie("application.cookie.prefix");
        this.DEFAULT_LANGUAGE = this.getDefaultLanguage(this.ninjaProperties);
    }

    @Override
    public void clearLanguage(Result result) {
        Cookie defaultLangCookie = this.generateNinjaLanguageCookie();
        result.unsetCookie(defaultLangCookie.getName());
    }

    @Override
    public Result setLanguage(String locale, Result result) {
        Cookie defaultLangCookie = this.generateNinjaLanguageCookie();
        Cookie cookie = Cookie.builder(defaultLangCookie).setValue(locale).build();
        result.addCookie(cookie);
        return result;
    }

    @Override
    public Optional<String> getLanguage(Context context, Optional<Result> result) {
        Cookie cookie;
        Cookie defaultCookie = this.generateNinjaLanguageCookie();
        if (result.isPresent() && (cookie = ((Result)result.get()).getCookie(defaultCookie.getName())) != null && cookie.getValue() != null && !cookie.getValue().isEmpty()) {
            return Optional.of((Object)cookie.getValue());
        }
        cookie = context.getCookie(defaultCookie.getName());
        if (cookie != null && cookie.getValue() != null && !cookie.getValue().isEmpty()) {
            return Optional.of((Object)cookie.getValue());
        }
        String acceptLanguage = context.getAcceptLanguage();
        if (acceptLanguage == null) {
            return Optional.absent();
        }
        Iterable languages = Splitter.on((String)",").trimResults().split((CharSequence)acceptLanguage);
        Iterator iterator = languages.iterator();
        if (iterator.hasNext()) {
            String language = (String)iterator.next();
            if (language.contains(";")) {
                language = language.split(";")[0];
                return Optional.of((Object)language);
            }
            return Optional.of((Object)language);
        }
        return Optional.absent();
    }

    private Cookie generateNinjaLanguageCookie() {
        Cookie cookie = Cookie.builder(this.applicationCookiePrefix + "_LANG", "").setMaxAge(315360000).build();
        return cookie;
    }

    @Override
    public boolean isLanguageDirectlySupportedByThisApplication(String language) {
        String applicationLanguages = this.ninjaProperties.get("application.languages");
        Iterable languages = Splitter.on((String)",").trimResults().split((CharSequence)applicationLanguages);
        for (String applicationLanguage : languages) {
            if (!applicationLanguage.equals(language)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Locale getLocaleFromStringOrDefault(Optional<String> language) {
        if (language.isPresent()) {
            return Locale.forLanguageTag((String)language.get());
        }
        return Locale.forLanguageTag(this.DEFAULT_LANGUAGE);
    }

    String getDefaultLanguage(NinjaProperties ninjaProperties) {
        String[] applicationLanguages = ninjaProperties.getStringArray("application.languages");
        if (applicationLanguages == null || applicationLanguages.length == 0) {
            String EXCEPTION_TEXT = "Can not retrieve application languages from ninjaProperties. Did you forget to define at least one language in your application.conf file? For instance 'application.languages=en' makes 'en' your default language.";
            throw new IllegalStateException(EXCEPTION_TEXT);
        }
        String defaultLanguage = applicationLanguages[0];
        return defaultLanguage;
    }
}

