/*
 * Decompiled with CFR 0.152.
 */
package ninja.diagnostics;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import ninja.diagnostics.SourceSnippet;

public class SourceSnippetHelper {
    public static SourceSnippet readFromQualifiedSourceCodePath(File baseDirectory, String packageName, String fileName, int lineFrom, int lineTo) throws IOException {
        if (baseDirectory != null) {
            File templateFile = new File(baseDirectory.getAbsolutePath() + File.separator + packageName.replace(".", File.separator) + File.separator + fileName);
            return SourceSnippetHelper.readFromFile(templateFile, lineFrom, lineTo);
        }
        return null;
    }

    public static SourceSnippet readFromRelativeFilePath(File baseDirectory, String templateRelativePath, int lineFrom, int lineTo) throws IOException {
        if (baseDirectory != null && templateRelativePath != null) {
            File templateFile = new File(baseDirectory.getAbsolutePath() + File.separator + templateRelativePath);
            return SourceSnippetHelper.readFromFile(templateFile, lineFrom, lineTo);
        }
        return null;
    }

    public static SourceSnippet readFromFile(File file, int lineFrom, int lineTo) throws IOException {
        if (file != null && file.exists()) {
            try (FileInputStream fis = new FileInputStream(file);){
                URI source = file.toURI();
                SourceSnippet sourceSnippet = SourceSnippetHelper.readFromInputStream(fis, source, lineFrom, lineTo);
                return sourceSnippet;
            }
        }
        return null;
    }

    private static SourceSnippet readFromInputStream(InputStream is, URI source, int lineFrom, int lineTo) throws IOException {
        String line;
        int intendedRange;
        if (lineFrom < 1 && lineTo > 0) {
            intendedRange = lineTo - lineFrom;
            lineFrom = 1;
            lineTo = lineFrom + intendedRange;
        } else if (lineFrom < 0 && lineTo < 0) {
            if (lineFrom < lineTo) {
                intendedRange = -1 * (lineFrom - lineTo);
                lineFrom = 1;
                lineTo = lineFrom + intendedRange;
            } else {
                return null;
            }
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(is, Charsets.UTF_8));
        ArrayList<String> lines = new ArrayList<String>();
        int i = 0;
        while ((line = in.readLine()) != null) {
            if (++i < lineFrom) continue;
            if (i > lineTo) break;
            lines.add(line);
        }
        if (lines.isEmpty()) {
            return null;
        }
        return new SourceSnippet(source, lines, lineFrom, lineFrom + lines.size() - 1);
    }
}

