/*
 * Decompiled with CFR 0.152.
 */
package ninja.diagnostics;

import java.net.URI;
import java.util.List;
import ninja.Context;
import ninja.Renderable;
import ninja.Result;
import ninja.diagnostics.DiagnosticErrorRenderer;

public class DiagnosticError
implements Renderable {
    private final String title;
    private final Throwable throwable;
    private final URI sourceLocation;
    private final List<String> sourceLines;
    private final int lineNumberOfSourceLines;
    private final int lineNumberOfError;
    private final Result underlyingResult;

    public DiagnosticError(String title, Throwable throwable, Result underlyingResult) {
        this(title, throwable, null, null, -1, -1, underlyingResult);
    }

    public DiagnosticError(String title, Throwable throwable, URI sourceLocation, List<String> sourceLines, int lineNumberOfSourceLines, int lineNumberOfError, Result underlyingResult) {
        this.throwable = throwable;
        this.title = title;
        this.sourceLocation = sourceLocation;
        this.sourceLines = sourceLines;
        this.lineNumberOfSourceLines = lineNumberOfSourceLines;
        this.lineNumberOfError = lineNumberOfError;
        this.underlyingResult = underlyingResult;
    }

    public String getTitle() {
        return this.title;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public URI getSourceLocation() {
        return this.sourceLocation;
    }

    public List<String> getSourceLines() {
        return this.sourceLines;
    }

    public int getLineNumberOfSourceLines() {
        return this.lineNumberOfSourceLines;
    }

    public int getLineNumberOfError() {
        return this.lineNumberOfError;
    }

    public Result getUnderlyingResult() {
        return this.underlyingResult;
    }

    @Override
    public void render(Context context, Result result) {
        DiagnosticErrorRenderer.tryToRender(context, result, this, true);
    }
}

