/*
 * Decompiled with CFR 0.152.
 */
package ninja.cache;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Map;
import ninja.cache.Cache;
import ninja.cache.CacheException;
import ninja.utils.TimeUtil;

@Singleton
public class NinjaCache {
    final Cache cache;

    @Inject
    public NinjaCache(Cache cache) {
        this.cache = cache;
    }

    public void add(String key, Object value, String expiration) {
        this.checkSerializable(value);
        this.cache.add(key, value, TimeUtil.parseDuration(expiration));
    }

    public boolean safeAdd(String key, Object value, String expiration) {
        this.checkSerializable(value);
        return this.cache.safeAdd(key, value, TimeUtil.parseDuration(expiration));
    }

    public void add(String key, Object value) {
        this.checkSerializable(value);
        this.cache.add(key, value, TimeUtil.parseDuration(null));
    }

    public void set(String key, Object value, String expiration) {
        this.checkSerializable(value);
        this.cache.set(key, value, TimeUtil.parseDuration(expiration));
    }

    public boolean safeSet(String key, Object value, String expiration) {
        this.checkSerializable(value);
        return this.cache.safeSet(key, value, TimeUtil.parseDuration(expiration));
    }

    public void set(String key, Object value) {
        this.checkSerializable(value);
        this.cache.set(key, value, TimeUtil.parseDuration(null));
    }

    public void replace(String key, Object value, String expiration) {
        this.checkSerializable(value);
        this.cache.replace(key, value, TimeUtil.parseDuration(expiration));
    }

    public boolean safeReplace(String key, Object value, String expiration) {
        this.checkSerializable(value);
        return this.cache.safeReplace(key, value, TimeUtil.parseDuration(expiration));
    }

    public void replace(String key, Object value) {
        this.checkSerializable(value);
        this.cache.replace(key, value, TimeUtil.parseDuration(null));
    }

    public long incr(String key, int by) {
        return this.cache.incr(key, by);
    }

    public long incr(String key) {
        return this.cache.incr(key, 1);
    }

    public long decr(String key, int by) {
        return this.cache.decr(key, by);
    }

    public long decr(String key) {
        return this.cache.decr(key, 1);
    }

    public Object get(String key) {
        return this.cache.get(key);
    }

    public Map<String, Object> get(String ... key) {
        return this.cache.get(key);
    }

    public void delete(String key) {
        this.cache.delete(key);
    }

    public boolean safeDelete(String key) {
        return this.cache.safeDelete(key);
    }

    public void clear() {
        this.cache.clear();
    }

    public <T> T get(String key, Class<T> clazz) {
        return (T)this.cache.get(key);
    }

    void checkSerializable(Object value) {
        if (value != null && !(value instanceof Serializable)) {
            throw new CacheException("Cannot cache a non-serializable value of type " + value.getClass().getName(), new NotSerializableException(value.getClass().getName()));
        }
    }
}

