/*
 * Decompiled with CFR 0.152.
 */
package ninja.bodyparser;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ninja.Context;
import ninja.bodyparser.BodyParserEngine;
import ninja.params.ParamParsers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BodyParserEnginePost
implements BodyParserEngine {
    private final Logger logger = LoggerFactory.getLogger(BodyParserEnginePost.class);
    private final ParamParsers paramParsers;

    @Inject
    public BodyParserEnginePost(ParamParsers paramParsers) {
        this.paramParsers = paramParsers;
    }

    @Override
    public <T> T invoke(Context context, Class<T> classOfT) {
        Map<String, String[]> parameters = context.getParameters();
        return this.invoke(context, parameters, classOfT, "");
    }

    private <T> T invoke(Context context, Map<String, String[]> parameters, Class<T> classOfT, String paramPrefix) {
        T t = null;
        try {
            t = classOfT.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.logger.error("Can't create new instance of class {}", (Object)classOfT.getName(), (Object)e);
            return null;
        }
        for (String declaredField : this.getAllDeclaredFieldsAsStringSet(classOfT)) {
            try {
                Field field = classOfT.getDeclaredField(declaredField);
                Class<?> fieldType = field.getType();
                field.setAccessible(true);
                if (parameters.containsKey(paramPrefix + declaredField)) {
                    Object parser;
                    String[] values = parameters.get(paramPrefix + declaredField);
                    if (Collection.class.isAssignableFrom(fieldType) || List.class.isAssignableFrom(fieldType)) {
                        parser = this.paramParsers.getListParser(this.getGenericType(field));
                        if (parser == null) {
                            this.logger.warn("No parser defined for a collection of type {}", (Object)this.getGenericType(field).getCanonicalName());
                            continue;
                        }
                        field.set(t, ((ParamParsers.ListParamParser)parser).parseParameter(field.getName(), values, context.getValidation()));
                        continue;
                    }
                    if (fieldType.isArray()) {
                        parser = this.paramParsers.getArrayParser(fieldType);
                        if (parser == null) {
                            this.logger.warn("No parser defined for an array of type {}", (Object)fieldType.getComponentType().getCanonicalName());
                            continue;
                        }
                        field.set(t, ((ParamParsers.ArrayParamParser)parser).parseParameter(field.getName(), values, context.getValidation()));
                        continue;
                    }
                    parser = this.paramParsers.getParamParser(fieldType);
                    if (parser == null) {
                        this.logger.warn("No parser defined for type {}", (Object)fieldType.getCanonicalName());
                        continue;
                    }
                    field.set(t, parser.parseParameter(field.getName(), values[0], context.getValidation()));
                    continue;
                }
                for (String parameter : parameters.keySet()) {
                    if (!parameter.startsWith(paramPrefix + declaredField + ".") || !this.isEmptyParameter(parameters.get(parameter))) continue;
                    field.set(t, this.invoke(context, parameters, fieldType, paramPrefix + declaredField + "."));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                this.logger.warn("Error parsing incoming Post request into class {}. Key {} and value {}.", new Object[]{classOfT.getName(), paramPrefix + declaredField, parameters.get(paramPrefix + declaredField), e});
            }
        }
        return t;
    }

    private boolean isEmptyParameter(String[] parameterValues) {
        if (parameterValues != null && parameterValues.length > 0) {
            for (String parameterValue : parameterValues) {
                if (parameterValue == null || parameterValue.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getContentType() {
        return "application/x-www-form-urlencoded";
    }

    private <T> Set<String> getAllDeclaredFieldsAsStringSet(Class<T> clazz) {
        HashSet declaredFields = Sets.newHashSet();
        for (Field field : clazz.getDeclaredFields()) {
            declaredFields.add(field.getName());
        }
        return declaredFields;
    }

    private Class<?> getGenericType(Field field) {
        ParameterizedType genericType = (ParameterizedType)field.getGenericType();
        return (Class)genericType.getActualTypeArguments()[0];
    }
}

