/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ninja.Context;
import ninja.Cookie;
import ninja.Renderable;
import ninja.exceptions.InternalServerErrorException;
import ninja.utils.DateUtil;
import ninja.utils.NoHttpBody;
import ninja.utils.ResponseStreams;
import ninja.utils.SwissKnife;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Result {
    private final Logger logger = LoggerFactory.getLogger(Result.class);
    public static final int SC_200_OK = 200;
    public static final int SC_201_CREATED = 201;
    public static final int SC_204_NO_CONTENT = 204;
    public static final int SC_300_MULTIPLE_CHOICES = 300;
    public static final int SC_301_MOVED_PERMANENTLY = 301;
    public static final int SC_302_FOUND = 302;
    public static final int SC_303_SEE_OTHER = 303;
    public static final int SC_304_NOT_MODIFIED = 304;
    public static final int SC_307_TEMPORARY_REDIRECT = 307;
    public static final int SC_400_BAD_REQUEST = 400;
    public static final int SC_401_UNAUTHORIZED = 401;
    public static final int SC_403_FORBIDDEN = 403;
    public static final int SC_404_NOT_FOUND = 404;
    public static final int SC_500_INTERNAL_SERVER_ERROR = 500;
    public static final int SC_501_NOT_IMPLEMENTED = 501;
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String APPLICATION_JSON = "application/json";
    @Deprecated
    public static final String APPLICATON_JSON = "application/json";
    public static final String APPLICATION_JSONP = "application/javascript";
    @Deprecated
    public static final String APPLICATON_JSONP = "application/javascript";
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final NoHttpBody NO_HTTP_BODY = new NoHttpBody();
    public static final String LOCATION = "Location";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CACHE_CONTROL_DEFAULT_NOCACHE_VALUE = "no-cache, no-store, max-age=0, must-revalidate";
    public static final String DATE = "Date";
    public static final String EXPIRES = "Expires";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private int statusCode;
    private Class<?> jsonView;
    private Object renderable;
    private String contentType;
    private Optional<String> fallbackContentType = Optional.absent();
    private final List<String> supportedContentTypes = Lists.newArrayList();
    private static final List<String> DEFAULT_SUPPORTED_CONTENT_TYPES = ImmutableList.of((Object)"text/html", (Object)"application/json", (Object)"application/xml");
    private String charset;
    private Map<String, String> headers;
    private List<Cookie> cookies;
    private String template;

    public Result(int statusCode) {
        this.statusCode = statusCode;
        this.charset = "utf-8";
        this.headers = Maps.newHashMap();
        this.cookies = Lists.newArrayList();
    }

    public Object getRenderable() {
        return this.renderable;
    }

    public Result render(Object object) {
        if (this.renderable == null) {
            this.renderable = object;
        } else {
            Map<String, Object> map;
            this.assertObjectNoRenderableOrThrowException(this.renderable);
            if (this.renderable instanceof Map) {
                map = (Map)this.renderable;
            } else {
                map = Maps.newHashMap();
                map.put(SwissKnife.getRealClassNameLowerCamelCase(this.renderable), this.renderable);
                this.renderable = map;
            }
            String key = SwissKnife.getRealClassNameLowerCamelCase(object);
            if (map.containsKey(key)) {
                throw new IllegalArgumentException(String.format("Cannot store object with default name %s.An object with the same name is already stored.Consider using render(key, value) to name objects implicitly.", key));
            }
            map.put(SwissKnife.getRealClassNameLowerCamelCase(object), object);
        }
        return this;
    }

    public Result render(Map<String, Object> mapToRender) {
        this.renderable = mapToRender;
        return this;
    }

    public Result render(Map.Entry<String, Object> entry) {
        if (this.renderable == null) {
            HashMap map = Maps.newHashMap();
            this.renderable = map;
            map.put(entry.getKey(), entry.getValue());
        } else {
            Map<String, Object> map;
            this.assertObjectNoRenderableOrThrowException(this.renderable);
            if (this.renderable instanceof Map) {
                map = (Map)this.renderable;
                if (map.containsKey(entry.getKey())) {
                    throw new IllegalArgumentException(String.format("Entry with key %s already stored inside this Result object. This is currently not supported and does not make sense. Consider using your own map.", entry.getKey()));
                }
                map.put(entry.getKey(), entry.getValue());
            } else {
                map = Maps.newHashMap();
                map.put(SwissKnife.getRealClassNameLowerCamelCase(this.renderable), this.renderable);
                this.renderable = map;
            }
            map.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Result render(Renderable renderable) {
        this.renderable = renderable;
        return this;
    }

    public Result render(String key, Object value) {
        this.render(new AbstractMap.SimpleEntry<String, Object>(key, value));
        return this;
    }

    @Deprecated
    public Result renderRaw(final String string) {
        Renderable renderable = new Renderable(){

            @Override
            public void render(Context context, Result result) {
                if (result.getContentType() == null) {
                    result.contentType(Result.TEXT_PLAIN);
                }
                ResponseStreams resultJsonCustom = context.finalizeHeaders(result);
                try (Writer writer = resultJsonCustom.getWriter();){
                    writer.write(string);
                }
                catch (IOException ioException) {
                    Result.this.logger.error("Error rendering raw String via renderRaw(...)", (Throwable)ioException);
                }
            }
        };
        this.render(renderable);
        return this;
    }

    public Result renderRaw(final byte[] bytes) {
        Renderable renderable = new Renderable(){

            @Override
            public void render(Context context, Result result) {
                if (result.getContentType() == null) {
                    result.contentType(Result.APPLICATION_OCTET_STREAM);
                }
                ResponseStreams responseStreams = context.finalizeHeaders(result);
                try (OutputStream outputStream = responseStreams.getOutputStream();){
                    outputStream.write(bytes);
                }
                catch (IOException ioException) {
                    throw new InternalServerErrorException(ioException);
                }
            }
        };
        this.render(renderable);
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharset() {
        return this.charset;
    }

    public Result charset(String charset) {
        this.charset = charset;
        return this;
    }

    @Deprecated
    public Result setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Result contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Result supportedContentType(String contentTypeSupportedByThisResult) {
        this.supportedContentTypes.add(contentTypeSupportedByThisResult);
        return this;
    }

    public Result supportedContentTypes(String ... contentTypesSupportedByThisResult) {
        this.supportedContentTypes.addAll(Arrays.asList(contentTypesSupportedByThisResult));
        return this;
    }

    public List<String> supportedContentTypes() {
        if (this.supportedContentTypes.isEmpty()) {
            return DEFAULT_SUPPORTED_CONTENT_TYPES;
        }
        return ImmutableList.copyOf(this.supportedContentTypes);
    }

    public Optional<String> fallbackContentType() {
        return this.fallbackContentType;
    }

    public Result fallbackContentType(String fallbackContentType) {
        this.fallbackContentType = Optional.of((Object)fallbackContentType);
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Result addHeader(String headerName, String headerContent) {
        this.headers.put(headerName, headerContent);
        return this;
    }

    public Cookie getCookie(String cookieName) {
        for (Cookie cookie : this.getCookies()) {
            if (!cookie.getName().equals(cookieName)) continue;
            return cookie;
        }
        return null;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public Result addCookie(Cookie cookie) {
        this.cookies.add(cookie);
        return this;
    }

    public Result unsetCookie(String name) {
        this.cookies.add(Cookie.builder(name, "").setMaxAge(0).build());
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Result status(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public String getTemplate() {
        return this.template;
    }

    public Result template(String template) {
        this.template = template;
        return this;
    }

    public Class<?> getJsonView() {
        return this.jsonView;
    }

    public Result jsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
        return this;
    }

    public Result redirect(String url) {
        this.status(303);
        this.addHeader(LOCATION, url);
        return this;
    }

    public Result redirectTemporary(String url) {
        this.status(307);
        this.addHeader(LOCATION, url);
        return this;
    }

    public Result html() {
        this.contentType = TEXT_HTML;
        return this;
    }

    public Result json() {
        this.contentType = "application/json";
        return this;
    }

    public Result jsonp() {
        this.contentType = "application/javascript";
        return this;
    }

    public Result text() {
        this.contentType = TEXT_PLAIN;
        return this;
    }

    public Result xml() {
        this.contentType = APPLICATION_XML;
        return this;
    }

    public Result doNotCacheContent() {
        this.addHeader(CACHE_CONTROL, CACHE_CONTROL_DEFAULT_NOCACHE_VALUE);
        this.addHeader(DATE, DateUtil.formatForHttpHeader(System.currentTimeMillis()));
        this.addHeader(EXPIRES, DateUtil.formatForHttpHeader(0L));
        return this;
    }

    private void assertObjectNoRenderableOrThrowException(Object object) {
        if (object instanceof Renderable) {
            throw new IllegalArgumentException("You already want to render a Renderable class. Adding more items to render is not supported.");
        }
    }
}

