/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.io.InputStream;
import java.util.Properties;
import javax.management.RuntimeErrorException;
import ninja.Context;
import ninja.Ninja;
import ninja.Result;
import ninja.Results;
import ninja.Route;
import ninja.Router;
import ninja.diagnostics.DiagnosticError;
import ninja.diagnostics.DiagnosticErrorBuilder;
import ninja.exceptions.BadRequestException;
import ninja.exceptions.RenderingException;
import ninja.i18n.Messages;
import ninja.lifecycle.LifecycleService;
import ninja.utils.Message;
import ninja.utils.NinjaProperties;
import ninja.utils.ResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NinjaDefault
implements Ninja {
    private static final Logger logger = LoggerFactory.getLogger(NinjaDefault.class);
    private final String NINJA_LOGO = "\n _______  .___ _______        ____.  _____   \n \\      \\ |   |\\      \\      |    | /  _  \\  \n /   |   \\|   |/   |   \\     |    |/  /_\\  \\ \n/    |    \\   /    |    \\/\\__|    /    |    \\  http://www.ninjaframework.org\n\\____|__  /___\\____|__  /\\________\\____|__  /  @ninjaframework\n     web\\/framework   \\/                  \\/   {}\n";
    @Inject
    protected LifecycleService lifecycleService;
    @Inject
    protected Router router;
    @Inject
    protected ResultHandler resultHandler;
    @Inject
    Messages messages;
    @Inject
    NinjaProperties ninjaProperties;

    public boolean isDiagnosticsEnabled() {
        return this.ninjaProperties.isDev() && this.ninjaProperties.getBooleanWithDefault("application.diagnostics", Boolean.TRUE) != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRouteRequest(Context.Impl context) {
        String httpMethod = context.getMethod();
        Route route = this.router.getRouteFor(httpMethod, context.getRequestPath());
        context.setRoute(route);
        if (route != null) {
            Result underlyingResult = null;
            try {
                underlyingResult = route.getFilterChain().next(context);
                this.resultHandler.handleResult(underlyingResult, context);
            }
            catch (Exception exception) {
                Result result = this.onException(context, exception, underlyingResult);
                this.renderErrorResultAndCatchAndLogExceptions(result, context);
            }
            finally {
                context.cleanup();
            }
        } else {
            Result result = this.getNotFoundResult(context);
            this.renderErrorResultAndCatchAndLogExceptions(result, context);
        }
    }

    @Override
    public void renderErrorResultAndCatchAndLogExceptions(Result result, Context context) {
        try {
            if (context.isAsync()) {
                context.returnResultAsync(result);
            } else {
                this.resultHandler.handleResult(result, context);
            }
        }
        catch (Exception exceptionCausingRenderError) {
            logger.error("Unable to handle result. That's really really fishy.", (Throwable)exceptionCausingRenderError);
        }
    }

    @Override
    public void onFrameworkStart() {
        this.showSplashScreenViaLogger();
        this.lifecycleService.start();
    }

    @Override
    public void onFrameworkShutdown() {
        this.lifecycleService.stop();
    }

    @Override
    public Result onException(Context context, Exception exception) {
        return this.onException(context, exception, null);
    }

    public Result onException(Context context, Exception exception, Result underlyingResult) {
        Result result;
        logger.debug("Unable to process request", (Throwable)exception);
        if (exception instanceof BadRequestException) {
            result = this.getBadRequestResult(context, exception);
        } else if (exception instanceof RenderingException) {
            RenderingException renderingException = (RenderingException)exception;
            result = this.getRenderingExceptionResult(context, renderingException, underlyingResult);
        } else {
            result = this.getInternalServerErrorResult(context, exception, underlyingResult);
        }
        return result;
    }

    public Result getRenderingExceptionResult(Context context, RenderingException exception, Result underlyingResult) {
        if (this.isDiagnosticsEnabled()) {
            DiagnosticError diagnosticError = DiagnosticErrorBuilder.buildDiagnosticError(exception.getTitle() == null ? "Rendering exception" : exception.getTitle(), exception.getCause() == null ? exception : exception.getCause(), exception.getSourcePath(), exception.getLineNumber(), underlyingResult);
            return Results.internalServerError().render(diagnosticError);
        }
        return this.getInternalServerErrorResult(context, exception);
    }

    @Override
    public Result getInternalServerErrorResult(Context context, Exception exception) {
        return this.getInternalServerErrorResult(context, exception, null);
    }

    public Result getInternalServerErrorResult(Context context, Exception exception, Result underlyingResult) {
        if (this.isDiagnosticsEnabled()) {
            DiagnosticError diagnosticError = DiagnosticErrorBuilder.build500InternalServerErrorDiagnosticError(exception, true, underlyingResult);
            return Results.internalServerError().render(diagnosticError);
        }
        logger.error("Emitting bad request 500. Something really wrong when calling route: {} (class: {} method: {})", new Object[]{context.getRequestPath(), context.getRoute().getControllerClass(), context.getRoute().getControllerMethod(), exception});
        String messageI18n = this.messages.getWithDefault("ninja.system.internal_server_error.text", "Oops. That''s an internal server error and all we know.", context, (Optional<Result>)Optional.absent(), new Object[0]);
        Message message = new Message(messageI18n);
        Result result = Results.internalServerError().supportedContentTypes("text/html", "application/json", "application/xml").fallbackContentType("text/html").render(message).template(this.ninjaProperties.getWithDefault("application.views.500internalServerError", "views/system/500internalServerError.ftl.html"));
        return result;
    }

    @Override
    public Result getNotFoundResult(Context context) {
        if (this.isDiagnosticsEnabled()) {
            DiagnosticError diagnosticError = DiagnosticErrorBuilder.build404NotFoundDiagnosticError(true);
            return Results.notFound().render(diagnosticError);
        }
        String messageI18n = this.messages.getWithDefault("ninja.system.not_found.text", "Oops. The requested route cannot be found.", context, (Optional<Result>)Optional.absent(), new Object[0]);
        Message message = new Message(messageI18n);
        Result result = Results.notFound().supportedContentTypes("text/html", "application/json", "application/xml").fallbackContentType("text/html").render(message).template(this.ninjaProperties.getWithDefault("application.views.404notFound", "views/system/404notFound.ftl.html"));
        return result;
    }

    @Override
    public Result getBadRequestResult(Context context, Exception exception) {
        if (this.isDiagnosticsEnabled()) {
            DiagnosticError diagnosticError = DiagnosticErrorBuilder.build400BadRequestDiagnosticError(exception, true);
            return Results.badRequest().render(diagnosticError);
        }
        String messageI18n = this.messages.getWithDefault("ninja.system.bad_request.text", "Oops. That''s a bad request and all we know.", context, (Optional<Result>)Optional.absent(), new Object[0]);
        Message message = new Message(messageI18n);
        Result result = Results.badRequest().supportedContentTypes("text/html", "application/json", "application/xml").fallbackContentType("text/html").render(message).template(this.ninjaProperties.getWithDefault("application.views.400badRequest", "views/system/400badRequest.ftl.html"));
        return result;
    }

    @Override
    public Result getUnauthorizedResult(Context context) {
        if (this.isDiagnosticsEnabled()) {
            DiagnosticError diagnosticError = DiagnosticErrorBuilder.build401UnauthorizedDiagnosticError();
            return Results.unauthorized().render(diagnosticError);
        }
        String messageI18n = this.messages.getWithDefault("ninja.system.unauthorized.text", "Oops. You are unauthorized.", context, (Optional<Result>)Optional.absent(), new Object[0]);
        Message message = new Message(messageI18n);
        Result result = Results.unauthorized().addHeader("WWW-Authenticate", "None").supportedContentTypes("text/html", "application/json", "application/xml").fallbackContentType("text/html").render(message).template(this.ninjaProperties.getWithDefault("application.views.401unauthorized", "views/system/401unauthorized.ftl.html"));
        return result;
    }

    @Override
    public Result getForbiddenResult(Context context) {
        if (this.isDiagnosticsEnabled()) {
            DiagnosticError diagnosticError = DiagnosticErrorBuilder.build403ForbiddenDiagnosticError();
            return Results.forbidden().render(diagnosticError);
        }
        String messageI18n = this.messages.getWithDefault("ninja.system.forbidden.text", "Oops. That''s forbidden and all we know.", context, (Optional<Result>)Optional.absent(), new Object[0]);
        Message message = new Message(messageI18n);
        Result result = Results.forbidden().supportedContentTypes("text/html", "application/json", "application/xml").fallbackContentType("text/html").render(message).template(this.ninjaProperties.getWithDefault("application.views.403forbidden", "views/system/403forbidden.ftl.html"));
        return result;
    }

    private final String readNinjaVersion() {
        String ninjaVersion;
        String LOCATION_OF_NINJA_BUILTIN_PROPERTIES = "ninja/ninja-builtin.properties";
        String NINJA_VERSION_PROPERTY_KEY = "ninja.version";
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(LOCATION_OF_NINJA_BUILTIN_PROPERTIES);){
            Properties prop = new Properties();
            prop.load(stream);
            ninjaVersion = prop.getProperty(NINJA_VERSION_PROPERTY_KEY);
        }
        catch (Exception e) {
            throw new RuntimeErrorException(new Error("Something is wrong with your build. Cannot find resource " + LOCATION_OF_NINJA_BUILTIN_PROPERTIES));
        }
        return ninjaVersion;
    }

    private final void showSplashScreenViaLogger() {
        String ninjaVersion = this.readNinjaVersion();
        logger.info("\n _______  .___ _______        ____.  _____   \n \\      \\ |   |\\      \\      |    | /  _  \\  \n /   |   \\|   |/   |   \\     |    |/  /_\\  \\ \n/    |    \\   /    |    \\/\\__|    /    |    \\  http://www.ninjaframework.org\n\\____|__  /___\\____|__  /\\________\\____|__  /  @ninjaframework\n     web\\/framework   \\/                  \\/   {}\n", (Object)ninjaVersion);
    }
}

