/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.inject.Provider;
import ninja.AsyncResult;
import ninja.Context;
import ninja.FilterChain;
import ninja.Result;
import ninja.params.ControllerMethodInvoker;

class FilterChainEnd
implements FilterChain {
    private Provider<?> controllerProvider;
    private ControllerMethodInvoker controllerMethodInvoker;
    private Result result;

    FilterChainEnd(Result result) {
        this.result = result;
    }

    FilterChainEnd(Provider<?> controllerProvider, ControllerMethodInvoker controllerMethodInvoker) {
        this.controllerProvider = controllerProvider;
        this.controllerMethodInvoker = controllerMethodInvoker;
    }

    @Override
    public Result next(Context context) {
        if (this.result != null) {
            return this.result;
        }
        Result controllerResult = (Result)this.controllerMethodInvoker.invoke(this.controllerProvider.get(), context);
        if (controllerResult instanceof AsyncResult) {
            context.handleAsync();
            Result newResult = context.controllerReturned();
            if (newResult != null) {
                controllerResult = newResult;
            }
        }
        return controllerResult;
    }
}

