/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.common.base.Preconditions;

public class Cookie {
    private final String name;
    private final String value;
    private final String comment;
    private final String domain;
    private final int maxAge;
    private final String path;
    private final boolean secure;
    private final boolean httpOnly;

    public Cookie(String name, String value, String comment, String domain, int maxAge, String path, boolean secure, boolean httpOnly) {
        this.name = name;
        this.value = value;
        this.comment = comment;
        this.domain = domain;
        this.maxAge = maxAge;
        this.path = path;
        this.secure = secure;
        this.httpOnly = httpOnly;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getComment() {
        return this.comment;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cookie cookie = (Cookie)o;
        if (this.httpOnly != cookie.httpOnly) {
            return false;
        }
        if (this.maxAge != cookie.maxAge) {
            return false;
        }
        if (this.secure != cookie.secure) {
            return false;
        }
        if (this.comment != null ? !this.comment.equals(cookie.comment) : cookie.comment != null) {
            return false;
        }
        if (this.domain != null ? !this.domain.equals(cookie.domain) : cookie.domain != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(cookie.name) : cookie.name != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(cookie.path) : cookie.path != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(cookie.value) : cookie.value != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
        result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
        result = 31 * result + this.maxAge;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.secure ? 1 : 0);
        result = 31 * result + (this.httpOnly ? 1 : 0);
        return result;
    }

    public static Builder builder(String name, String value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        return new Builder(name, value);
    }

    public static Builder builder(Cookie like) {
        return new Builder(like);
    }

    public static class Builder {
        private final String name;
        private String value;
        private String comment;
        private String domain;
        private int maxAge = -1;
        private String path = "/";
        private boolean secure;
        private boolean httpOnly;

        private Builder(String name, String value) {
            this.name = name;
            this.value = value;
        }

        private Builder(Cookie like) {
            this.name = like.name;
            this.value = like.value;
            this.comment = like.comment;
            this.domain = like.domain;
            this.maxAge = like.maxAge;
            this.path = like.path;
            this.secure = like.secure;
            this.httpOnly = like.httpOnly;
        }

        public Cookie build() {
            return new Cookie(this.name, this.value, this.comment, this.domain, this.maxAge, this.path, this.secure, this.httpOnly);
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public Builder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder setMaxAge(int maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder setHttpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }
    }
}

