/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.cursor.defaults;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.cursor.CursorException;
import org.apache.ibatis.executor.resultset.DefaultResultSetHandler;
import org.apache.ibatis.executor.resultset.ResultSetWrapper;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class DefaultCursor<T>
implements Cursor<T> {
    private final DefaultResultSetHandler resultSetHandler;
    private final ResultMap resultMap;
    private final ResultSetWrapper rsw;
    private final RowBounds rowBounds;
    private final ObjectWrapperResultHandler<T> objectWrapperResultHandler = new ObjectWrapperResultHandler();
    private CursorIterator cursorIterator = new CursorIterator();
    private boolean iteratorRetrieved = false;
    private CursorStatus status = CursorStatus.CREATED;
    private int indexWithRowBound = -1;

    public DefaultCursor(DefaultResultSetHandler resultSetHandler, ResultMap resultMap, ResultSetWrapper rsw, RowBounds rowBounds) {
        this.resultSetHandler = resultSetHandler;
        this.resultMap = resultMap;
        this.rsw = rsw;
        this.rowBounds = rowBounds;
    }

    @Override
    public boolean isOpen() {
        return this.status == CursorStatus.OPEN;
    }

    @Override
    public boolean isConsumed() {
        return this.status == CursorStatus.CONSUMED;
    }

    @Override
    public int getCurrentIndex() {
        return this.rowBounds.getOffset() + this.cursorIterator.iteratorIndex;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.iteratorRetrieved) {
            throw new IllegalStateException("Cannot open more than one iterator on a Cursor");
        }
        this.iteratorRetrieved = true;
        return this.cursorIterator;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        ResultSet rs = this.rsw.getResultSet();
        try {
            if (rs != null) {
                Statement statement = rs.getStatement();
                rs.close();
                if (statement != null) {
                    statement.close();
                }
            }
            this.status = CursorStatus.CLOSED;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected T fetchNextUsingRowBound() {
        T result = this.fetchNextObjectFromDatabase();
        while (result != null && this.indexWithRowBound < this.rowBounds.getOffset()) {
            result = this.fetchNextObjectFromDatabase();
        }
        return result;
    }

    protected T fetchNextObjectFromDatabase() {
        if (this.isClosed()) {
            return null;
        }
        try {
            this.status = CursorStatus.OPEN;
            this.resultSetHandler.handleRowValues(this.rsw, this.resultMap, this.objectWrapperResultHandler, RowBounds.DEFAULT, null);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        Object next = ((ObjectWrapperResultHandler)this.objectWrapperResultHandler).result;
        if (next != null) {
            ++this.indexWithRowBound;
        }
        if (next == null || this.getReadItemsCount() == this.rowBounds.getOffset() + this.rowBounds.getLimit()) {
            this.close();
            this.status = CursorStatus.CONSUMED;
        }
        ((ObjectWrapperResultHandler)this.objectWrapperResultHandler).result = null;
        return (T)next;
    }

    private boolean isClosed() {
        return this.status == CursorStatus.CLOSED || this.status == CursorStatus.CONSUMED;
    }

    private int getReadItemsCount() {
        return this.indexWithRowBound + 1;
    }

    private class CursorIterator
    implements Iterator<T> {
        T object;
        int iteratorIndex = -1;

        private CursorIterator() {
        }

        @Override
        public boolean hasNext() {
            if (DefaultCursor.this.isClosed()) {
                return false;
            }
            if (this.object == null) {
                this.object = DefaultCursor.this.fetchNextUsingRowBound();
            }
            return this.object != null;
        }

        @Override
        public T next() {
            if (DefaultCursor.this.isClosed()) {
                throw new CursorException("Cursor is closed");
            }
            Object next = this.object;
            if (next == null) {
                next = DefaultCursor.this.fetchNextUsingRowBound();
            }
            if (next != null) {
                this.object = null;
                ++this.iteratorIndex;
                return next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove element from Cursor");
        }
    }

    private static class ObjectWrapperResultHandler<E>
    implements ResultHandler<E> {
        private E result;

        private ObjectWrapperResultHandler() {
        }

        @Override
        public void handleResult(ResultContext<? extends E> context) {
            this.result = context.getResultObject();
            context.stop();
        }
    }

    private static enum CursorStatus {
        CREATED,
        OPEN,
        CLOSED,
        CONSUMED;

    }
}

