/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.keygen;

import java.sql.Statement;
import java.util.List;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.RowBounds;

public class SelectKeyGenerator
implements KeyGenerator {
    public static final String SELECT_KEY_SUFFIX = "!selectKey";
    private boolean executeBefore;
    private MappedStatement keyStatement;

    public SelectKeyGenerator(MappedStatement keyStatement, boolean executeBefore) {
        this.executeBefore = executeBefore;
        this.keyStatement = keyStatement;
    }

    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        if (this.executeBefore) {
            this.processGeneratedKeys(executor, ms, stmt, parameter);
        }
    }

    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        if (!this.executeBefore) {
            this.processGeneratedKeys(executor, ms, stmt, parameter);
        }
    }

    private void processGeneratedKeys(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        try {
            String keyStatementName;
            Configuration configuration = ms.getConfiguration();
            if (parameter != null && configuration.hasStatement(keyStatementName = ms.getId() + SELECT_KEY_SUFFIX) && this.keyStatement != null && this.keyStatement.getKeyProperties() != null) {
                String keyProperty = this.keyStatement.getKeyProperties()[0];
                MetaObject metaParam = configuration.newMetaObject(parameter);
                if (keyProperty != null && metaParam.hasSetter(keyProperty)) {
                    Executor keyExecutor = configuration.newExecutor(executor.getTransaction(), ExecutorType.SIMPLE);
                    List values = keyExecutor.query(this.keyStatement, parameter, RowBounds.DEFAULT, Executor.NO_RESULT_HANDLER);
                    if (values.size() > 1) {
                        throw new ExecutorException("Select statement for SelectKeyGenerator returned more than one value.");
                    }
                    metaParam.setValue(keyProperty, values.get(0));
                }
            }
        }
        catch (Exception e) {
            throw new ExecutorException("Error selecting key or setting result to parameter object. Cause: " + e, e);
        }
    }
}

