/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.ibatis.builder.BaseBuilder;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.IncompleteCacheException;
import org.apache.ibatis.builder.xml.IncompleteStatementException;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.decorators.LruCache;
import org.apache.ibatis.cache.impl.PerpetualCache;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.CacheBuilder;
import org.apache.ibatis.mapping.Discriminator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMap;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.ResultSetType;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.reflection.MetaClass;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperBuilderAssistant
extends BaseBuilder {
    private String currentNamespace;
    private String resource;
    private Cache currentCache;

    public MapperBuilderAssistant(Configuration configuration, String resource) {
        super(configuration);
        ErrorContext.instance().resource(resource);
        this.resource = resource;
    }

    public String getCurrentNamespace() {
        return this.currentNamespace;
    }

    public void setCurrentNamespace(String currentNamespace) {
        if (currentNamespace == null) {
            throw new BuilderException("The mapper element requires a namespace attribute to be specified.");
        }
        if (this.currentNamespace != null && !this.currentNamespace.equals(currentNamespace)) {
            throw new BuilderException("Wrong namespace. Expected '" + this.currentNamespace + "' but found '" + currentNamespace + "'.");
        }
        this.currentNamespace = currentNamespace;
    }

    public String applyCurrentNamespace(String base) {
        if (base == null) {
            return null;
        }
        if (base.contains(".")) {
            return base;
        }
        return this.currentNamespace + "." + base;
    }

    public Cache useCacheRef(String namespace) {
        if (namespace == null) {
            throw new BuilderException("cache-ref element requires a namespace attribute.");
        }
        try {
            Cache cache = this.configuration.getCache(namespace);
            if (cache == null) {
                throw new IncompleteCacheException("No cache for namespace '" + namespace + "' could be found.");
            }
            this.currentCache = cache;
            return cache;
        }
        catch (IllegalArgumentException e) {
            throw new IncompleteCacheException("No cache for namespace '" + namespace + "' could be found.", e);
        }
    }

    public Cache useNewCache(Class<? extends Cache> typeClass, Class<? extends Cache> evictionClass, Long flushInterval, Integer size, boolean readWrite, Properties props) {
        typeClass = this.valueOrDefault(typeClass, PerpetualCache.class);
        evictionClass = this.valueOrDefault(evictionClass, LruCache.class);
        Cache cache = new CacheBuilder(this.currentNamespace).implementation(typeClass).addDecorator(evictionClass).clearInterval(flushInterval).size(size).readWrite(readWrite).properties(props).build();
        this.configuration.addCache(cache);
        this.currentCache = cache;
        return cache;
    }

    public ParameterMap addParameterMap(String id, Class<?> parameterClass, List<ParameterMapping> parameterMappings) {
        id = this.applyCurrentNamespace(id);
        ParameterMap.Builder parameterMapBuilder = new ParameterMap.Builder(this.configuration, id, parameterClass, parameterMappings);
        ParameterMap parameterMap = parameterMapBuilder.build();
        this.configuration.addParameterMap(parameterMap);
        return parameterMap;
    }

    public ParameterMapping buildParameterMapping(Class<?> parameterType, String property, Class<?> javaType, JdbcType jdbcType, String resultMap, ParameterMode parameterMode, Class<? extends TypeHandler> typeHandler, Integer numericScale) {
        resultMap = this.applyCurrentNamespace(resultMap);
        Class<?> javaTypeClass = this.resolveParameterJavaType(parameterType, property, javaType, jdbcType);
        TypeHandler typeHandlerInstance = (TypeHandler)this.resolveInstance(typeHandler);
        ParameterMapping.Builder builder = new ParameterMapping.Builder(this.configuration, property, javaTypeClass);
        builder.jdbcType(jdbcType);
        builder.resultMapId(resultMap);
        builder.mode(parameterMode);
        builder.numericScale(numericScale);
        builder.typeHandler(typeHandlerInstance);
        return builder.build();
    }

    public ResultMap addResultMap(String id, Class<?> type, String extend, Discriminator discriminator, List<ResultMapping> resultMappings) {
        ResultMap resultMap;
        id = this.applyCurrentNamespace(id);
        extend = this.applyCurrentNamespace(extend);
        ResultMap.Builder resultMapBuilder = new ResultMap.Builder(this.configuration, id, type, resultMappings);
        if (extend != null) {
            resultMap = this.configuration.getResultMap(extend);
            resultMappings.addAll(resultMap.getResultMappings());
        }
        resultMapBuilder.discriminator(discriminator);
        resultMap = resultMapBuilder.build();
        this.configuration.addResultMap(resultMap);
        return resultMap;
    }

    public ResultMapping buildResultMapping(Class<?> resultType, String property, String column, Class<?> javaType, JdbcType jdbcType, String nestedSelect, String nestedResultMap, Class<? extends TypeHandler> typeHandler, List<ResultFlag> flags) {
        ResultMapping resultMapping = this.assembleResultMapping(resultType, property, column, javaType, jdbcType, nestedSelect, nestedResultMap, typeHandler, flags);
        return resultMapping;
    }

    public Discriminator buildDiscriminator(Class<?> resultType, String column, Class<?> javaType, JdbcType jdbcType, Class<? extends TypeHandler> typeHandler, Map<String, String> discriminatorMap) {
        ResultMapping resultMapping = this.assembleResultMapping(resultType, null, column, javaType, jdbcType, null, null, typeHandler, new ArrayList<ResultFlag>());
        HashMap<String, String> namespaceDiscriminatorMap = new HashMap<String, String>();
        for (Map.Entry<String, String> e : discriminatorMap.entrySet()) {
            String resultMap = e.getValue();
            resultMap = this.applyCurrentNamespace(resultMap);
            namespaceDiscriminatorMap.put(e.getKey(), resultMap);
        }
        Discriminator.Builder discriminatorBuilder = new Discriminator.Builder(this.configuration, resultMapping, namespaceDiscriminatorMap);
        return discriminatorBuilder.build();
    }

    public MappedStatement addMappedStatement(String id, SqlSource sqlSource, StatementType statementType, SqlCommandType sqlCommandType, Integer fetchSize, Integer timeout, String parameterMap, Class<?> parameterType, String resultMap, Class<?> resultType, ResultSetType resultSetType, boolean flushCache, boolean useCache, KeyGenerator keyGenerator, String keyProperty) {
        id = this.applyCurrentNamespace(id);
        boolean isSelect = sqlCommandType == SqlCommandType.SELECT;
        MappedStatement.Builder statementBuilder = new MappedStatement.Builder(this.configuration, id, sqlSource, sqlCommandType);
        statementBuilder.resource(this.resource);
        statementBuilder.fetchSize(fetchSize);
        statementBuilder.statementType(statementType);
        statementBuilder.keyGenerator(keyGenerator);
        statementBuilder.keyProperty(keyProperty);
        this.setStatementTimeout(timeout, statementBuilder);
        this.setStatementParameterMap(parameterMap, parameterType, statementBuilder);
        this.setStatementResultMap(resultMap, resultType, resultSetType, statementBuilder);
        this.setStatementCache(isSelect, flushCache, useCache, this.currentCache, statementBuilder);
        MappedStatement statement = statementBuilder.build();
        this.configuration.addMappedStatement(statement);
        return statement;
    }

    private <T> T valueOrDefault(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    private void setStatementCache(boolean isSelect, boolean flushCache, boolean useCache, Cache cache, MappedStatement.Builder statementBuilder) {
        flushCache = this.valueOrDefault(flushCache, !isSelect);
        useCache = this.valueOrDefault(useCache, isSelect);
        statementBuilder.flushCacheRequired(flushCache);
        statementBuilder.useCache(useCache);
        statementBuilder.cache(cache);
    }

    private void setStatementParameterMap(String parameterMap, Class<?> parameterTypeClass, MappedStatement.Builder statementBuilder) {
        if ((parameterMap = this.applyCurrentNamespace(parameterMap)) != null) {
            try {
                statementBuilder.parameterMap(this.configuration.getParameterMap(parameterMap));
            }
            catch (IllegalArgumentException e) {
                throw new IncompleteStatementException("Could not find parameter map " + parameterMap, e);
            }
        } else if (parameterTypeClass != null) {
            ArrayList<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
            ParameterMap.Builder inlineParameterMapBuilder = new ParameterMap.Builder(this.configuration, statementBuilder.id() + "-Inline", parameterTypeClass, parameterMappings);
            statementBuilder.parameterMap(inlineParameterMapBuilder.build());
        }
    }

    private void setStatementResultMap(String resultMap, Class<?> resultType, ResultSetType resultSetType, MappedStatement.Builder statementBuilder) {
        resultMap = this.applyCurrentNamespace(resultMap);
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        if (resultMap != null) {
            String[] resultMapNames;
            for (String resultMapName : resultMapNames = resultMap.split(",")) {
                try {
                    resultMaps.add(this.configuration.getResultMap(resultMapName.trim()));
                }
                catch (IllegalArgumentException e) {
                    throw new IncompleteStatementException("Could not find result map " + resultMapName, e);
                }
            }
        } else if (resultType != null) {
            ResultMap.Builder inlineResultMapBuilder = new ResultMap.Builder(this.configuration, statementBuilder.id() + "-Inline", resultType, new ArrayList<ResultMapping>());
            resultMaps.add(inlineResultMapBuilder.build());
        }
        statementBuilder.resultMaps(resultMaps);
        statementBuilder.resultSetType(resultSetType);
    }

    private void setStatementTimeout(Integer timeout, MappedStatement.Builder statementBuilder) {
        if (timeout == null) {
            timeout = this.configuration.getDefaultStatementTimeout();
        }
        statementBuilder.timeout(timeout);
    }

    private ResultMapping assembleResultMapping(Class<?> resultType, String property, String column, Class<?> javaType, JdbcType jdbcType, String nestedSelect, String nestedResultMap, Class<? extends TypeHandler> typeHandler, List<ResultFlag> flags) {
        nestedResultMap = this.applyCurrentNamespace(nestedResultMap);
        Class<?> javaTypeClass = this.resolveResultJavaType(resultType, property, javaType);
        TypeHandler typeHandlerInstance = (TypeHandler)this.resolveInstance(typeHandler);
        List<ResultMapping> composites = this.parseCompositeColumnName(column);
        if (composites.size() > 0) {
            ResultMapping first = composites.get(0);
            column = first.getColumn();
        }
        ResultMapping.Builder builder = new ResultMapping.Builder(this.configuration, property, column, javaTypeClass);
        builder.jdbcType(jdbcType);
        builder.nestedQueryId(this.applyCurrentNamespace(nestedSelect));
        builder.nestedResultMapId(this.applyCurrentNamespace(nestedResultMap));
        builder.typeHandler(typeHandlerInstance);
        builder.flags(flags == null ? new ArrayList() : flags);
        builder.composites(composites);
        return builder.build();
    }

    private List<ResultMapping> parseCompositeColumnName(String columnName) {
        ArrayList<ResultMapping> composites = new ArrayList<ResultMapping>();
        if (columnName != null && (columnName.indexOf(61) > -1 || columnName.indexOf(44) > -1)) {
            StringTokenizer parser = new StringTokenizer(columnName, "{}=, ", false);
            while (parser.hasMoreTokens()) {
                String property = parser.nextToken();
                String column = parser.nextToken();
                ResultMapping.Builder complexBuilder = new ResultMapping.Builder(this.configuration, property, column, this.configuration.getTypeHandlerRegistry().getUnknownTypeHandler());
                composites.add(complexBuilder.build());
            }
        }
        return composites;
    }

    private Class<?> resolveResultJavaType(Class<?> resultType, String property, Class<?> javaType) {
        if (javaType == null && property != null) {
            try {
                MetaClass metaResultType = MetaClass.forClass(resultType);
                javaType = metaResultType.getSetterType(property);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (javaType == null) {
            javaType = Object.class;
        }
        return javaType;
    }

    private Class<?> resolveParameterJavaType(Class<?> resultType, String property, Class<?> javaType, JdbcType jdbcType) {
        if (javaType == null) {
            if (JdbcType.CURSOR.equals((Object)jdbcType)) {
                javaType = ResultSet.class;
            } else if (Map.class.isAssignableFrom(resultType)) {
                javaType = Object.class;
            } else {
                MetaClass metaResultType = MetaClass.forClass(resultType);
                javaType = metaResultType.getGetterType(property);
            }
        }
        if (javaType == null) {
            javaType = Object.class;
        }
        return javaType;
    }
}

