/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.java;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InitializationBlock;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.JavaDomUtils;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.Method;

public class InnerClass
extends JavaElement {
    private List<Field> fields;
    private List<InnerClass> innerClasses;
    private List<InnerEnum> innerEnums;
    private FullyQualifiedJavaType superClass;
    private FullyQualifiedJavaType type;
    private Set<FullyQualifiedJavaType> superInterfaceTypes;
    private List<Method> methods;
    private boolean isAbstract;
    private List<InitializationBlock> initializationBlocks;

    public InnerClass(FullyQualifiedJavaType type) {
        this.type = type;
        this.fields = new ArrayList<Field>();
        this.innerClasses = new ArrayList<InnerClass>();
        this.innerEnums = new ArrayList<InnerEnum>();
        this.superInterfaceTypes = new HashSet<FullyQualifiedJavaType>();
        this.methods = new ArrayList<Method>();
        this.initializationBlocks = new ArrayList<InitializationBlock>();
    }

    public InnerClass(String typeName) {
        this(new FullyQualifiedJavaType(typeName));
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void addField(Field field) {
        this.fields.add(field);
    }

    public FullyQualifiedJavaType getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(FullyQualifiedJavaType superClass) {
        this.superClass = superClass;
    }

    public void setSuperClass(String superClassType) {
        this.superClass = new FullyQualifiedJavaType(superClassType);
    }

    public List<InnerClass> getInnerClasses() {
        return this.innerClasses;
    }

    public void addInnerClass(InnerClass innerClass) {
        this.innerClasses.add(innerClass);
    }

    public List<InnerEnum> getInnerEnums() {
        return this.innerEnums;
    }

    public void addInnerEnum(InnerEnum innerEnum) {
        this.innerEnums.add(innerEnum);
    }

    public List<InitializationBlock> getInitializationBlocks() {
        return this.initializationBlocks;
    }

    public void addInitializationBlock(InitializationBlock initializationBlock) {
        this.initializationBlocks.add(initializationBlock);
    }

    public String getFormattedContent(int indentLevel, CompilationUnit compilationUnit) {
        StringBuilder sb = new StringBuilder();
        this.addFormattedJavadoc(sb, indentLevel);
        this.addFormattedAnnotations(sb, indentLevel);
        OutputUtilities.javaIndent(sb, indentLevel);
        sb.append(this.getVisibility().getValue());
        if (this.isAbstract()) {
            sb.append("abstract ");
        }
        if (this.isStatic()) {
            sb.append("static ");
        }
        if (this.isFinal()) {
            sb.append("final ");
        }
        sb.append("class ");
        sb.append(this.getType().getShortName());
        if (this.superClass != null) {
            sb.append(" extends ");
            sb.append(JavaDomUtils.calculateTypeName(compilationUnit, this.superClass));
        }
        if (this.superInterfaceTypes.size() > 0) {
            sb.append(" implements ");
            boolean comma = false;
            for (FullyQualifiedJavaType fqjt : this.superInterfaceTypes) {
                if (comma) {
                    sb.append(", ");
                } else {
                    comma = true;
                }
                sb.append(JavaDomUtils.calculateTypeName(compilationUnit, fqjt));
            }
        }
        sb.append(" {");
        ++indentLevel;
        Iterator<Field> fldIter = this.fields.iterator();
        while (fldIter.hasNext()) {
            OutputUtilities.newLine(sb);
            Field field = fldIter.next();
            sb.append(field.getFormattedContent(indentLevel, compilationUnit));
            if (!fldIter.hasNext()) continue;
            OutputUtilities.newLine(sb);
        }
        if (this.initializationBlocks.size() > 0) {
            OutputUtilities.newLine(sb);
        }
        Iterator<InitializationBlock> blkIter = this.initializationBlocks.iterator();
        while (blkIter.hasNext()) {
            OutputUtilities.newLine(sb);
            InitializationBlock initializationBlock = blkIter.next();
            sb.append(initializationBlock.getFormattedContent(indentLevel));
            if (!blkIter.hasNext()) continue;
            OutputUtilities.newLine(sb);
        }
        if (this.methods.size() > 0) {
            OutputUtilities.newLine(sb);
        }
        Iterator<Method> mtdIter = this.methods.iterator();
        while (mtdIter.hasNext()) {
            OutputUtilities.newLine(sb);
            Method method = mtdIter.next();
            sb.append(method.getFormattedContent(indentLevel, false, compilationUnit));
            if (!mtdIter.hasNext()) continue;
            OutputUtilities.newLine(sb);
        }
        if (this.innerClasses.size() > 0) {
            OutputUtilities.newLine(sb);
        }
        Iterator<InnerClass> icIter = this.innerClasses.iterator();
        while (icIter.hasNext()) {
            OutputUtilities.newLine(sb);
            InnerClass innerClass = icIter.next();
            sb.append(innerClass.getFormattedContent(indentLevel, compilationUnit));
            if (!icIter.hasNext()) continue;
            OutputUtilities.newLine(sb);
        }
        if (this.innerEnums.size() > 0) {
            OutputUtilities.newLine(sb);
        }
        Iterator<InnerEnum> ieIter = this.innerEnums.iterator();
        while (ieIter.hasNext()) {
            OutputUtilities.newLine(sb);
            InnerEnum innerEnum = ieIter.next();
            sb.append(innerEnum.getFormattedContent(indentLevel, compilationUnit));
            if (!ieIter.hasNext()) continue;
            OutputUtilities.newLine(sb);
        }
        OutputUtilities.newLine(sb);
        OutputUtilities.javaIndent(sb, --indentLevel);
        sb.append('}');
        return sb.toString();
    }

    public Set<FullyQualifiedJavaType> getSuperInterfaceTypes() {
        return this.superInterfaceTypes;
    }

    public void addSuperInterface(FullyQualifiedJavaType superInterface) {
        this.superInterfaceTypes.add(superInterface);
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public void addMethod(Method method) {
        this.methods.add(method);
    }

    public FullyQualifiedJavaType getType() {
        return this.type;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbtract) {
        this.isAbstract = isAbtract;
    }
}

