/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mybatis.generator.api.GeneratedXmlFile;
import org.mybatis.generator.config.MergeConstants;
import org.mybatis.generator.exception.ShellException;
import org.mybatis.generator.internal.DomWriter;
import org.mybatis.generator.internal.util.messages.Messages;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlFileMergerJaxp {
    private XmlFileMergerJaxp() {
    }

    public static String getMergedSource(GeneratedXmlFile generatedXmlFile, File existingFile) throws ShellException {
        try {
            return XmlFileMergerJaxp.getMergedSource(new InputSource(new StringReader(generatedXmlFile.getFormattedContent())), new InputSource(new InputStreamReader((InputStream)new FileInputStream(existingFile), "UTF-8")), existingFile.getName());
        }
        catch (IOException e) {
            throw new ShellException(Messages.getString("Warning.13", existingFile.getName()), e);
        }
        catch (SAXException e) {
            throw new ShellException(Messages.getString("Warning.13", existingFile.getName()), e);
        }
        catch (ParserConfigurationException e) {
            throw new ShellException(Messages.getString("Warning.13", existingFile.getName()), e);
        }
    }

    public static String getMergedSource(InputSource newFile, InputSource existingFile, String existingFileName) throws IOException, SAXException, ParserConfigurationException, ShellException {
        Node node;
        int i;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new NullEntityResolver());
        Document existingDocument = builder.parse(existingFile);
        Document newDocument = builder.parse(newFile);
        DocumentType newDocType = newDocument.getDoctype();
        DocumentType existingDocType = existingDocument.getDoctype();
        if (!newDocType.getName().equals(existingDocType.getName())) {
            throw new ShellException(Messages.getString("Warning.12", existingFileName));
        }
        Element existingRootElement = existingDocument.getDocumentElement();
        Element newRootElement = newDocument.getDocumentElement();
        NamedNodeMap attributes = existingRootElement.getAttributes();
        int attributeCount = attributes.getLength();
        for (i = attributeCount - 1; i >= 0; --i) {
            node = attributes.item(i);
            existingRootElement.removeAttribute(node.getNodeName());
        }
        attributes = newRootElement.getAttributes();
        attributeCount = attributes.getLength();
        for (i = 0; i < attributeCount; ++i) {
            node = attributes.item(i);
            existingRootElement.setAttribute(node.getNodeName(), node.getNodeValue());
        }
        ArrayList<Node> nodesToDelete = new ArrayList<Node>();
        NodeList children = existingRootElement.getChildNodes();
        int length = children.getLength();
        for (int i2 = 0; i2 < length; ++i2) {
            Node node2 = children.item(i2);
            if (XmlFileMergerJaxp.isGeneratedNode(node2)) {
                nodesToDelete.add(node2);
                continue;
            }
            if (!XmlFileMergerJaxp.isWhiteSpace(node2) || !XmlFileMergerJaxp.isGeneratedNode(children.item(i2 + 1))) continue;
            nodesToDelete.add(node2);
        }
        for (Node node2 : nodesToDelete) {
            existingRootElement.removeChild(node2);
        }
        children = newRootElement.getChildNodes();
        length = children.getLength();
        Node firstChild = existingRootElement.getFirstChild();
        for (int i3 = 0; i3 < length; ++i3) {
            Node node3 = children.item(i3);
            if (i3 == length - 1 && XmlFileMergerJaxp.isWhiteSpace(node3)) break;
            Node newNode = existingDocument.importNode(node3, true);
            if (firstChild == null) {
                existingRootElement.appendChild(newNode);
                continue;
            }
            existingRootElement.insertBefore(newNode, firstChild);
        }
        return XmlFileMergerJaxp.prettyPrint(existingDocument);
    }

    private static String prettyPrint(Document document) throws ShellException {
        DomWriter dw = new DomWriter();
        String s = dw.toString(document);
        return s;
    }

    private static boolean isGeneratedNode(Node node) {
        boolean rc = false;
        if (node != null && node.getNodeType() == 1) {
            Element element = (Element)node;
            String id = element.getAttribute("id");
            if (id != null) {
                for (String prefix : MergeConstants.OLD_XML_ELEMENT_PREFIXES) {
                    if (!id.startsWith(prefix)) continue;
                    rc = true;
                    break;
                }
            }
            if (!rc) {
                NodeList children = node.getChildNodes();
                int length = children.getLength();
                block1: for (int i = 0; i < length; ++i) {
                    Node childNode = children.item(i);
                    if (XmlFileMergerJaxp.isWhiteSpace(childNode)) continue;
                    if (childNode.getNodeType() != 8) break;
                    Comment comment = (Comment)childNode;
                    String commentData = comment.getData();
                    for (String tag : MergeConstants.OLD_ELEMENT_TAGS) {
                        if (!commentData.contains(tag)) continue;
                        rc = true;
                        continue block1;
                    }
                }
            }
        }
        return rc;
    }

    private static boolean isWhiteSpace(Node node) {
        Text tn;
        boolean rc = false;
        if (node != null && node.getNodeType() == 3 && (tn = (Text)node).getData().trim().length() == 0) {
            rc = true;
        }
        return rc;
    }

    private static class NullEntityResolver
    implements EntityResolver {
        private NullEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            StringReader sr = new StringReader("");
            return new InputSource(sr);
        }
    }
}

