/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.caches.memcached;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.mybatis.caches.memcached.AbstractPropertySetter;
import org.mybatis.caches.memcached.BooleanPropertySetter;
import org.mybatis.caches.memcached.ConnectionFactorySetter;
import org.mybatis.caches.memcached.InetSocketAddressListPropertySetter;
import org.mybatis.caches.memcached.IntegerPropertySetter;
import org.mybatis.caches.memcached.MemcachedConfiguration;
import org.mybatis.caches.memcached.StringPropertySetter;
import org.mybatis.caches.memcached.TimeUnitSetter;

final class MemcachedConfigurationBuilder {
    private static final MemcachedConfigurationBuilder INSTANCE = new MemcachedConfigurationBuilder();
    private static final String SYSTEM_PROPERTY_MEMCACHED_PROPERTIES_FILENAME = "memcached.properties.filename";
    private static final String MEMCACHED_RESOURCE = "memcached.properties";
    private final String memcachedPropertiesFilename;
    private final List<AbstractPropertySetter<?>> settersRegistry = new ArrayList();

    public static MemcachedConfigurationBuilder getInstance() {
        return INSTANCE;
    }

    private MemcachedConfigurationBuilder() {
        this.memcachedPropertiesFilename = System.getProperty(SYSTEM_PROPERTY_MEMCACHED_PROPERTIES_FILENAME, MEMCACHED_RESOURCE);
        this.settersRegistry.add(new StringPropertySetter("org.mybatis.caches.memcached.keyprefix", "keyPrefix", "_mybatis_"));
        this.settersRegistry.add(new IntegerPropertySetter("org.mybatis.caches.memcached.expiration", "expiration", 2592000));
        this.settersRegistry.add(new IntegerPropertySetter("org.mybatis.caches.memcached.timeout", "timeout", 5));
        this.settersRegistry.add(new TimeUnitSetter());
        this.settersRegistry.add(new BooleanPropertySetter("org.mybatis.caches.memcached.asyncget", "usingAsyncGet", false));
        this.settersRegistry.add(new BooleanPropertySetter("org.mybatis.caches.memcached.compression", "compressionEnabled", false));
        this.settersRegistry.add(new InetSocketAddressListPropertySetter());
        this.settersRegistry.add(new ConnectionFactorySetter());
    }

    public MemcachedConfiguration parseConfiguration() {
        return this.parseConfiguration(this.getClass().getClassLoader());
    }

    public MemcachedConfiguration parseConfiguration(ClassLoader classLoader) {
        Properties config = new Properties();
        InputStream input = classLoader.getResourceAsStream(this.memcachedPropertiesFilename);
        if (input != null) {
            try {
                config.load(input);
            }
            catch (IOException e) {
                throw new RuntimeException("An error occurred while reading classpath property '" + this.memcachedPropertiesFilename + "', see nested exceptions", e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        MemcachedConfiguration memcachedConfiguration = new MemcachedConfiguration();
        for (AbstractPropertySetter<?> setter : this.settersRegistry) {
            setter.set(config, memcachedConfiguration);
        }
        return memcachedConfiguration;
    }
}

